/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.serviceregistry.version.VersionRule;
import org.apache.servicecomb.serviceregistry.version.VersionRuleUtils;

public class OperationInstancesDiscoveryFilter
extends AbstractDiscoveryFilter {
    public int getOrder() {
        return -20000;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.operation.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return true;
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        return invocation.getMicroserviceQualifiedName();
    }

    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        List microserviceVersions = CoreMetaUtils.getMicroserviceVersions(invocation).getVersions().values().stream().sorted(Comparator.comparing(MicroserviceVersion::getVersion)).collect(Collectors.toList());
        ConcurrentHashMapEx operationNodes = new ConcurrentHashMapEx();
        for (MicroserviceVersion microserviceVersion : microserviceVersions) {
            DiscoveryTreeNode shareNode = null;
            MicroserviceMeta microserviceMeta = CoreMetaUtils.getMicroserviceMeta(microserviceVersion);
            for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
                DiscoveryTreeNode node = (DiscoveryTreeNode)operationNodes.get(operationMeta.getMicroserviceQualifiedName());
                if (node == null) {
                    if (shareNode == null) {
                        Map instanceMap = microserviceVersion.getInstances().stream().collect(Collectors.toMap(MicroserviceInstance::getInstanceId, Function.identity()));
                        shareNode = this.createOperationNode(parent, microserviceVersion);
                        shareNode.data(instanceMap);
                    }
                    operationNodes.put(operationMeta.getMicroserviceQualifiedName(), shareNode);
                    continue;
                }
                microserviceVersion.getInstances().forEach(microserviceInstance -> node.mapData().put(microserviceInstance.getInstanceId(), microserviceInstance));
            }
        }
        parent.children((Map)operationNodes);
    }

    private DiscoveryTreeNode createOperationNode(DiscoveryTreeNode parent, MicroserviceVersion microserviceVersion) {
        VersionRule versionRule = VersionRuleUtils.getOrCreate((String)(microserviceVersion.getVersion().getVersion() + "+"));
        return (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, versionRule.getVersionRule()).data(new HashMap());
    }
}

