/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import java.util.Map;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceConfig;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class MicroserviceVersionsMeta {
    protected SCBEngine scbEngine;
    protected MicroserviceConfig microserviceConfig;
    private Map<String, OperationConfig> configs = new ConcurrentHashMapEx();

    public MicroserviceVersionsMeta(SCBEngine scbEngine, String microserviceName) {
        this.scbEngine = scbEngine;
        this.microserviceConfig = (MicroserviceConfig)scbEngine.getPriorityPropertyManager().createConfigObject(MicroserviceConfig.class, new Object[]{"service", microserviceName});
    }

    public void destroy() {
        this.scbEngine.getPriorityPropertyManager().unregisterConfigObject((Object)this.microserviceConfig);
        this.configs.values().stream().forEach(arg_0 -> ((PriorityPropertyManager)this.scbEngine.getPriorityPropertyManager()).unregisterConfigObject(arg_0));
    }

    public MicroserviceConfig getMicroserviceConfig() {
        return this.microserviceConfig;
    }

    public OperationConfig getOrCreateOperationConfig(OperationMeta operationMeta) {
        return this.configs.computeIfAbsent(operationMeta.getMicroserviceQualifiedName(), name -> this.createOperationConfig(operationMeta));
    }

    private OperationConfig createOperationConfig(OperationMeta operationMeta) {
        boolean consumer = operationMeta.getMicroserviceMeta().isConsumer();
        return (OperationConfig)this.scbEngine.getPriorityPropertyManager().createConfigObject(OperationConfig.class, new Object[]{"op-any-priority", consumer ? OperationConfig.CONSUMER_OP_ANY_PRIORITY : OperationConfig.PRODUCER_OP_ANY_PRIORITY, "consumer-op-any_priority", OperationConfig.CONSUMER_OP_ANY_PRIORITY, "producer-op-any_priority", OperationConfig.PRODUCER_OP_ANY_PRIORITY, "op-priority", consumer ? OperationConfig.CONSUMER_OP_PRIORITY : OperationConfig.PRODUCER_OP_PRIORITY, "consumer-op-priority", OperationConfig.CONSUMER_OP_PRIORITY, "producer-op-priority", OperationConfig.PRODUCER_OP_PRIORITY, "consumer-producer", consumer ? "Consumer" : "Provider", "consumer-provider", consumer ? "Consumer" : "Provider", "service", operationMeta.getMicroserviceName(), "schema", operationMeta.getSchemaId(), "operation", operationMeta.getOperationId()});
    }
}

