/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.ConsumerProvider;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

public class CseApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered,
ApplicationContextAware {
    private Class<?> initEventClass = ContextRefreshedEvent.class;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        BeanUtils.setContext((ApplicationContext)applicationContext);
        RegistryUtils.init();
        SCBEngine.getInstance();
    }

    public void setInitEventClass(Class<?> initEventClass) {
        this.initEventClass = initEventClass;
    }

    public int getOrder() {
        return -1000;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.initEventClass.isInstance(event)) {
            if (this.applicationContext instanceof AbstractApplicationContext) {
                ((AbstractApplicationContext)this.applicationContext).registerShutdownHook();
            }
            SCBEngine scbEngine = SCBEngine.getInstance();
            scbEngine.getConsumerProviderManager().getConsumerProviderList().addAll(this.applicationContext.getBeansOfType(ConsumerProvider.class).values());
            scbEngine.getProducerProviderManager().getProducerProviderList().addAll(this.applicationContext.getBeansOfType(ProducerProvider.class).values());
            scbEngine.addBootListeners(this.applicationContext.getBeansOfType(BootListener.class).values());
            scbEngine.run();
        } else if (event instanceof ContextClosedEvent && SCBEngine.getInstance() != null) {
            SCBEngine.getInstance().destroy();
        }
    }
}

