/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.HystrixCacheKeyGenerator;
import com.netflix.hystrix.contrib.javanica.cache.HystrixGeneratedCacheKey;
import com.netflix.hystrix.contrib.javanica.cache.HystrixRequestCacheManager;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheResult;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.LazyCommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractHystrixCommand<T>
extends HystrixCommand<T> {
    private final CommandActions commandActions;
    private final CacheInvocationContext<CacheResult> cacheResultInvocationContext;
    private final CacheInvocationContext<CacheRemove> cacheRemoveInvocationContext;
    private final Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests;
    private final List<Class<? extends Throwable>> ignoreExceptions;
    private final ExecutionType executionType;
    private final HystrixCacheKeyGenerator defaultCacheKeyGenerator = HystrixCacheKeyGenerator.getInstance();

    protected AbstractHystrixCommand(HystrixCommandBuilder builder) {
        super(builder.getSetterBuilder().build());
        this.commandActions = builder.getCommandActions();
        this.collapsedRequests = builder.getCollapsedRequests();
        this.cacheResultInvocationContext = builder.getCacheResultInvocationContext();
        this.cacheRemoveInvocationContext = builder.getCacheRemoveInvocationContext();
        this.ignoreExceptions = builder.getIgnoreExceptions();
        this.executionType = builder.getExecutionType();
    }

    protected CommandAction getCommandAction() {
        return this.commandActions.getCommandAction();
    }

    protected CommandAction getFallbackAction() {
        return this.commandActions.getFallbackAction();
    }

    protected Collection<HystrixCollapser.CollapsedRequest<Object, Object>> getCollapsedRequests() {
        return this.collapsedRequests;
    }

    protected List<Class<? extends Throwable>> getIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    protected ExecutionType getExecutionType() {
        return this.executionType;
    }

    protected String getCacheKey() {
        String key = null;
        if (this.cacheResultInvocationContext != null) {
            HystrixGeneratedCacheKey hystrixGeneratedCacheKey = this.defaultCacheKeyGenerator.generateCacheKey(this.cacheResultInvocationContext);
            key = hystrixGeneratedCacheKey.getCacheKey();
        }
        return key;
    }

    boolean isIgnorable(Throwable throwable) {
        if (this.ignoreExceptions == null || this.ignoreExceptions.isEmpty()) {
            return false;
        }
        for (Class<? extends Throwable> ignoreException : this.ignoreExceptions) {
            if (!ignoreException.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    Object process(Action action) throws Exception {
        Object result;
        try {
            result = action.execute();
            this.flushCache();
        }
        catch (CommandActionExecutionException throwable) {
            Throwable cause = throwable.getCause();
            if (this.isIgnorable(cause)) {
                throw new HystrixBadRequestException(cause.getMessage(), cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new CommandActionExecutionException(cause);
        }
        return result;
    }

    protected abstract T run() throws Exception;

    protected T getFallback() {
        throw new RuntimeException("No fallback available.", this.getExecutionException());
    }

    protected void flushCache() {
        if (this.cacheRemoveInvocationContext != null) {
            HystrixRequestCacheManager.getInstance().clearCache(this.cacheRemoveInvocationContext);
        }
    }

    static class FallbackErrorMessageBuilder {
        private StringBuilder builder = new StringBuilder("failed to processed fallback");

        FallbackErrorMessageBuilder() {
        }

        static FallbackErrorMessageBuilder create() {
            return new FallbackErrorMessageBuilder();
        }

        public FallbackErrorMessageBuilder append(CommandAction action, Throwable throwable) {
            return this.commandAction(action).exception(throwable);
        }

        private FallbackErrorMessageBuilder commandAction(CommandAction action) {
            if (action instanceof CommandExecutionAction || action instanceof LazyCommandExecutionAction) {
                this.builder.append(": '").append(action.getActionName()).append("'. ").append(action.getActionName()).append(" fallback is a hystrix command. ");
            } else if (action instanceof MethodExecutionAction) {
                this.builder.append(" is the method: '").append(action.getActionName()).append("'. ");
            }
            return this;
        }

        private FallbackErrorMessageBuilder exception(Throwable throwable) {
            if (throwable instanceof HystrixBadRequestException) {
                this.builder.append("exception: '").append(throwable.getCause().getClass()).append("' occurred in fallback was ignored and wrapped to HystrixBadRequestException.\n");
            } else if (throwable instanceof HystrixRuntimeException) {
                this.builder.append("exception: '").append(throwable.getCause().getClass()).append("' occurred in fallback wasn't ignored.\n");
            }
            return this;
        }

        public String build() {
            return this.builder.toString();
        }
    }

    abstract class Action {
        Action() {
        }

        abstract Object execute() throws CommandActionExecutionException;
    }
}

