/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.ext.web.RoutingContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.springframework.util.StringUtils;

public class DatetimeConfigurableItem
implements AccessLogItem<RoutingContext> {
    public static final String DEFAULT_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private final ThreadLocal<SimpleDateFormat> datetimeFormatHolder = new ThreadLocal();
    private String pattern;
    private TimeZone timezone;
    private Locale locale;

    public DatetimeConfigurableItem() {
        this(DEFAULT_DATETIME_PATTERN);
    }

    public DatetimeConfigurableItem(String config) {
        String[] configArr = null;
        if (config.contains("|")) {
            configArr = this.splitConfig(config);
        } else {
            configArr = new String[3];
            configArr[0] = config;
        }
        if (3 != configArr.length) {
            throw new IllegalArgumentException("wrong format of configuration, \"PATTERN|TIMEZONE|LOCALE\" is expected, but actually is \"" + config + "\"");
        }
        this.setConfigruations(configArr);
    }

    private String[] splitConfig(String config) {
        return config.split("\\|{1}?", -1);
    }

    private void setConfigruations(String[] configArr) {
        this.pattern = StringUtils.isEmpty((Object)configArr[0]) ? DEFAULT_DATETIME_PATTERN : configArr[0];
        this.timezone = StringUtils.isEmpty((Object)configArr[1]) ? TimeZone.getDefault() : TimeZone.getTimeZone(configArr[1]);
        this.locale = StringUtils.isEmpty((Object)configArr[2]) ? DEFAULT_LOCALE : Locale.forLanguageTag(configArr[2]);
    }

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        SimpleDateFormat dateFormat = this.getDatetimeFormat();
        return dateFormat.format(new Date(accessLogParam.getStartMillisecond()));
    }

    private SimpleDateFormat getDatetimeFormat() {
        SimpleDateFormat dateFormat = this.datetimeFormatHolder.get();
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(this.pattern, this.locale);
            dateFormat.setTimeZone(this.timezone);
            this.datetimeFormatHolder.set(dateFormat);
        }
        return dateFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

