/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import reactor.netty.http.server.AccessLog;

final class AccessLogHandler
extends ChannelDuplexHandler {
    AccessLog accessLog = new AccessLog();

    AccessLogHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            SocketChannel channel = (SocketChannel)ctx.channel();
            this.accessLog = new AccessLog().address(channel.remoteAddress().getHostString()).port(channel.localAddress().getPort()).method(request.method().name()).uri(request.uri()).protocol(request.protocolVersion().text());
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)response);
            this.accessLog.status((CharSequence)status.codeAsText()).chunked(chunked);
            if (!chunked) {
                this.accessLog.contentLength(HttpUtil.getContentLength((HttpMessage)response, (int)-1));
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLog.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            ctx.write(msg, promise.unvoid()).addListener(future -> {
                if (future.isSuccess()) {
                    this.accessLog.log();
                }
            });
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLog.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLog.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

