/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.http;

import io.vertx.core.Context;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientPoolFactory
implements ClientPoolFactory<HttpClientWithContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientPoolFactory.class);
    private HttpClientOptions httpClientOptions;

    public HttpClientPoolFactory(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
    }

    @Override
    public HttpClientWithContext createClientPool(Context context) {
        HttpClient httpClient = context.owner().createHttpClient(this.httpClientOptions);
        httpClient.connectionHandler(connection -> {
            LOGGER.debug("http connection connected, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress());
            connection.closeHandler(v -> LOGGER.debug("http connection closed, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress()));
            connection.exceptionHandler(e -> LOGGER.info("http connection exception, local:{}, remote:{}.", new Object[]{connection.localAddress(), connection.remoteAddress(), e}));
        });
        return new HttpClientWithContext(httpClient, context);
    }
}

