/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.common;

import com.netflix.config.DynamicPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportConfigUtils.class);

    private TransportConfigUtils() {
    }

    public static int readVerticleCount(String key, String deprecatedKey) {
        int count = DynamicPropertyFactory.getInstance().getIntProperty(key, -1).get();
        if (count > 0) {
            return count;
        }
        count = DynamicPropertyFactory.getInstance().getIntProperty(deprecatedKey, -1).get();
        if (count > 0) {
            LOGGER.warn("{} is ambiguous, and deprecated, recommended to use {}.", (Object)deprecatedKey, (Object)key);
            return count;
        }
        count = Runtime.getRuntime().availableProcessors() > 8 ? 8 : Runtime.getRuntime().availableProcessors();
        LOGGER.info("{} not defined, set to {}.", (Object)key, (Object)count);
        return count;
    }
}

