/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.queue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.tools.ChronicleTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.codec.JavaSerializationCodec;
import reactor.io.queue.QueuePersistor;

public class ChronicleQueuePersistor<T>
implements QueuePersistor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ChronicleQueuePersistor.class);
    private final Object monitor = new Object();
    private final AtomicLong lastId = new AtomicLong();
    private final AtomicLong size = new AtomicLong(0L);
    private final ExcerptTailer exTrailer;
    private final ExcerptTailer indexTrailer;
    private final ExcerptAppender exAppender;
    private final String basePath;
    private final Codec<Buffer, T, T> codec;
    private final boolean deleteOnExit;
    private final Chronicle data;

    public ChronicleQueuePersistor(@Nonnull String basePath) throws IOException {
        this(basePath, new JavaSerializationCodec(), false, false, (ChronicleQueueBuilder)ChronicleQueueBuilder.vanilla((String)basePath));
    }

    public ChronicleQueuePersistor(@Nonnull String basePath, @Nonnull Codec<Buffer, T, T> codec, boolean clearOnStart, boolean deleteOnExit, @Nonnull ChronicleQueueBuilder config) throws IOException {
        this.basePath = basePath;
        this.codec = codec;
        this.deleteOnExit = deleteOnExit;
        this.data = config.build();
        this.lastId.set(this.data.lastWrittenIndex());
        if (clearOnStart) {
            this.data.clear();
        }
        ChronicleTools.warmup();
        Excerpt ex = this.data.createExcerpt();
        ex.skip(4L);
        while (ex.nextIndex()) {
            int len = ex.readInt();
            this.size.incrementAndGet();
            ex.skip((long)len);
        }
        this.indexTrailer = this.data.createTailer();
        this.exTrailer = this.data.createTailer();
        this.exAppender = this.data.createAppender();
    }

    @Override
    public void close() {
        try {
            this.data.close();
            if (this.deleteOnExit) {
                this.data.clear();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public long lastId() {
        return this.lastId.get();
    }

    @Override
    public long size() {
        return this.size.get();
    }

    @Override
    public boolean hasNext() {
        return this.indexTrailer.nextIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long offer(@Nonnull T t) {
        Object object = this.monitor;
        synchronized (object) {
            Buffer buff = (Buffer)this.codec.apply(t);
            int len = buff.remaining();
            this.exAppender.startExcerpt((long)(4 + len));
            this.exAppender.writeInt(len);
            this.exAppender.write(buff.byteBuffer());
            this.exAppender.finish();
            this.size.incrementAndGet();
            this.lastId.set(this.exAppender.lastWrittenIndex());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Offered {} to Chronicle at index {}, size {}", new Object[]{t, this.lastId(), this.size()});
        }
        return this.lastId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long offerAll(@Nonnull Collection<T> t) {
        if (t.isEmpty()) {
            return this.lastId();
        }
        Codec<Buffer, T, T> encoder = this.codec;
        int elasticity = 16;
        Object object = this.monitor;
        synchronized (object) {
            long count = 0L;
            for (T v : t) {
                Buffer buff = (Buffer)encoder.apply(v);
                int len = buff.remaining();
                if (count++ == 0L) {
                    this.exAppender.startExcerpt((long)(4 + elasticity * t.size() * len));
                }
                this.exAppender.writeInt(len);
                this.exAppender.write(buff.byteBuffer());
                this.size.incrementAndGet();
            }
            this.lastId.set(this.exAppender.lastWrittenIndex());
            this.exAppender.finish();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Offered {} to Chronicle at index {}, size {}", new Object[]{t, this.lastId(), this.size()});
        }
        return this.lastId();
    }

    @Override
    public T get(Long id) {
        if (!this.exTrailer.index(id.longValue())) {
            return null;
        }
        return this.read((ExcerptCommon)this.exTrailer);
    }

    public Codec<Buffer, T, T> codec() {
        return this.codec;
    }

    public ExcerptTailer reader() {
        return this.indexTrailer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() {
        Object object = this.monitor;
        synchronized (object) {
            T obj = this.read((ExcerptCommon)this.indexTrailer);
            this.size.decrementAndGet();
            return obj;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return ChronicleQueuePersistor.this.hasNext();
            }

            @Override
            public T next() {
                return ChronicleQueuePersistor.this.read((ExcerptCommon)ChronicleQueuePersistor.this.indexTrailer);
            }

            @Override
            public void remove() {
                throw new IllegalStateException("This Iterator is read-only.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T read(ExcerptCommon ex) {
        try {
            int len = ex.readInt();
            ByteBuffer bb = ByteBuffer.allocate(len);
            ex.read(bb);
            bb.flip();
            T t = this.codec.decoder(null).apply(new Buffer(bb));
            return t;
        }
        finally {
            ex.finish();
        }
    }
}

