/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.support.Exceptions;

public class SubscriberWithContext<T, C>
implements Subscriber<T> {
    private volatile int terminated = 0;
    protected static final AtomicIntegerFieldUpdater<SubscriberWithContext> TERMINAL_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SubscriberWithContext.class, "terminated");
    protected final C context;
    protected final Subscriber<? super T> subscriber;

    public static <T, C> SubscriberWithContext<T, C> create(Subscriber<? super T> subscriber, C context) {
        return new SubscriberWithContext<T, C>(context, subscriber);
    }

    protected SubscriberWithContext(C context, Subscriber<? super T> subscriber) {
        this.context = context;
        this.subscriber = subscriber;
    }

    public C context() {
        return this.context;
    }

    public void onSubscribe(Subscription s) {
        try {
            this.subscriber.onSubscribe(s);
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            this.subscriber.onError(throwable);
        }
    }

    public void onNext(T t) {
        try {
            this.subscriber.onNext(t);
        }
        catch (Throwable throwable) {
            this.subscriber.onError(Exceptions.addValueAsLastCause(throwable, t));
        }
    }

    public void onError(Throwable t) {
        if (TERMINAL_UPDATER.compareAndSet(this, 0, 1)) {
            this.subscriber.onError(t);
        }
    }

    public void onComplete() {
        try {
            if (TERMINAL_UPDATER.compareAndSet(this, 0, 1)) {
                this.subscriber.onComplete();
            }
        }
        catch (Throwable throwable) {
            this.subscriber.onError(throwable);
        }
    }

    public boolean isCancelled() {
        return this.terminated == 1;
    }
}

