/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import com.google.common.collect.ImmutableMap;
import io.github.swagger2markup.internal.adapter.PropertyAdapter;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ArrayType;
import io.github.swagger2markup.internal.type.BasicType;
import io.github.swagger2markup.internal.type.EnumType;
import io.github.swagger2markup.internal.type.MapType;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.ObjectTypePolymorphism;
import io.github.swagger2markup.internal.type.RefType;
import io.github.swagger2markup.internal.type.Type;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.Property;
import io.swagger.models.refs.RefFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class ModelUtils {
    public static Type resolveRefType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof RefType) {
            return ModelUtils.resolveRefType(((RefType)type).getRefType());
        }
        return type;
    }

    public static Type getType(Model model, Map<String, Model> definitions, DocumentResolver definitionDocumentResolver) {
        Validate.notNull((Object)model, (String)"model must not be null!", (Object[])new Object[0]);
        if (model instanceof ModelImpl) {
            ModelImpl modelImpl = (ModelImpl)model;
            if (modelImpl.getAdditionalProperties() != null) {
                return new MapType(modelImpl.getTitle(), new PropertyAdapter(modelImpl.getAdditionalProperties()).getType(definitionDocumentResolver));
            }
            if (modelImpl.getEnum() != null) {
                return new EnumType(modelImpl.getTitle(), modelImpl.getEnum());
            }
            if (modelImpl.getProperties() != null) {
                ObjectType objectType = new ObjectType(modelImpl.getTitle(), model.getProperties());
                objectType.getPolymorphism().setDiscriminator(modelImpl.getDiscriminator());
                return objectType;
            }
            if (modelImpl.getType() == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)modelImpl.getFormat())) {
                return new BasicType(modelImpl.getType(), modelImpl.getTitle(), modelImpl.getFormat());
            }
            return new BasicType(modelImpl.getType(), modelImpl.getTitle());
        }
        if (model instanceof ComposedModel) {
            ComposedModel composedModel = (ComposedModel)model;
            LinkedHashMap<String, Property> allProperties = new LinkedHashMap<String, Property>();
            ObjectTypePolymorphism polymorphism = new ObjectTypePolymorphism(ObjectTypePolymorphism.Nature.NONE, null);
            String name = model.getTitle();
            if (composedModel.getAllOf() != null) {
                polymorphism.setNature(ObjectTypePolymorphism.Nature.COMPOSITION);
                for (Model innerModel : composedModel.getAllOf()) {
                    Map<String, Property> innerModelProperties;
                    Type innerModelType = ModelUtils.resolveRefType(ModelUtils.getType(innerModel, definitions, definitionDocumentResolver));
                    if (innerModelType != null) {
                        name = innerModelType.getName();
                    }
                    if (!(innerModelType instanceof ObjectType)) continue;
                    String innerModelDiscriminator = ((ObjectType)innerModelType).getPolymorphism().getDiscriminator();
                    if (innerModelDiscriminator != null) {
                        polymorphism.setNature(ObjectTypePolymorphism.Nature.INHERITANCE);
                        polymorphism.setDiscriminator(innerModelDiscriminator);
                    }
                    if ((innerModelProperties = ((ObjectType)innerModelType).getProperties()) == null) continue;
                    allProperties.putAll((Map<String, Property>)ImmutableMap.copyOf(innerModelProperties));
                }
            }
            return new ObjectType(name, polymorphism, allProperties);
        }
        if (model instanceof RefModel) {
            RefModel refModel = (RefModel)model;
            String refName = refModel.getRefFormat().equals((Object)RefFormat.INTERNAL) ? refModel.getSimpleRef() : refModel.getReference();
            Type refType = new ObjectType(refName, null);
            if (definitions.containsKey(refName)) {
                refType = ModelUtils.getType(definitions.get(refName), definitions, definitionDocumentResolver);
                refType.setName(refName);
                refType.setUniqueName(refName);
            }
            return new RefType((String)definitionDocumentResolver.apply(refName), refType);
        }
        if (model instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)model;
            return new ArrayType(null, new PropertyAdapter(arrayModel.getItems()).getType(definitionDocumentResolver));
        }
        return null;
    }
}

