/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import io.github.swagger2markup.internal.type.ArrayType;
import io.github.swagger2markup.internal.type.MapType;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.RefType;
import io.github.swagger2markup.internal.type.Type;
import java.util.List;
import org.apache.commons.collections4.MapUtils;

public class InlineSchemaUtils {
    public static Type createInlineType(Type type, String name, String uniqueName, List<ObjectType> inlineDefinitions) {
        if (type instanceof ObjectType) {
            return InlineSchemaUtils.createInlineObjectType(type, name, uniqueName, inlineDefinitions);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayType.setOfType(InlineSchemaUtils.createInlineType(arrayType.getOfType(), name, uniqueName, inlineDefinitions));
            return arrayType;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            if (mapType.getValueType() instanceof ObjectType) {
                mapType.setValueType(InlineSchemaUtils.createInlineType(mapType.getValueType(), name, uniqueName, inlineDefinitions));
            }
            return mapType;
        }
        return type;
    }

    private static Type createInlineObjectType(Type type, String name, String uniqueName, List<ObjectType> inlineDefinitions) {
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            if (MapUtils.isNotEmpty(objectType.getProperties())) {
                if (objectType.getName() == null) {
                    objectType.setName(name);
                    objectType.setUniqueName(uniqueName);
                }
                inlineDefinitions.add(objectType);
                return new RefType(objectType);
            }
            return type;
        }
        return type;
    }
}

