/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractDescriptor;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Range;
import io.protostuff.compiler.model.UserType;
import io.protostuff.compiler.model.UserTypeContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Enum
extends AbstractDescriptor
implements UserType {
    protected final UserTypeContainer parent;
    protected List<EnumConstant> constants = new ArrayList<EnumConstant>();
    protected Proto proto;
    protected String fullyQualifiedName;
    protected List<Range> reservedFieldRanges = new ArrayList<Range>();
    protected List<String> reservedFieldNames = new ArrayList<String>();

    public Enum(UserTypeContainer parent) {
        this.parent = parent;
    }

    public List<EnumConstant> getConstants() {
        return this.constants;
    }

    public void setConstants(List<EnumConstant> constants) {
        this.constants = constants;
    }

    public Set<String> getConstantNames() {
        return this.constants.stream().map(AbstractDescriptor::getName).collect(Collectors.toSet());
    }

    public EnumConstant getConstant(String name) {
        for (EnumConstant enumConstant : this.getConstants()) {
            if (!enumConstant.getName().equals(name)) continue;
            return enumConstant;
        }
        return null;
    }

    public void addConstant(EnumConstant value) {
        this.constants.add(value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("fullyQualifiedName", (Object)this.fullyQualifiedName).add("constants", this.constants).add("options", (Object)this.options).toString();
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.ENUM;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    @Override
    public void setProto(Proto proto) {
        this.proto = proto;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Override
    public String getCanonicalName() {
        String fqn = this.getFullyQualifiedName();
        if (fqn.startsWith(".")) {
            return fqn.substring(1);
        }
        return fqn;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public UserTypeContainer getParent() {
        return this.parent;
    }

    @Override
    public boolean isNested() {
        return this.getParent().getDescriptorType() != DescriptorType.PROTO;
    }

    @Override
    public void addReservedFieldRange(Range range) {
        this.reservedFieldRanges.add(range);
    }

    @Override
    public void addReservedFieldName(String fieldName) {
        this.reservedFieldNames.add(fieldName);
    }

    @Override
    public List<Range> getReservedFieldRanges() {
        return this.reservedFieldRanges;
    }

    @Override
    public List<String> getReservedFieldNames() {
        return this.reservedFieldNames;
    }
}

