/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.ReifyingAllocator;
import org.jruby.ext.ffi.SwappedMemoryIO;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;

@JRubyClass(name={"FFI::Pointer"}, parent="AbstractMemory")
public class Pointer
extends AbstractMemory {
    public static RubyClass createPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass pointerClass = module.defineClassUnder("Pointer", module.getClass("AbstractMemory"), (Boolean)Options.REIFY_FFI.load() != false ? new ReifyingAllocator(Pointer.class) : PointerAllocator.INSTANCE);
        pointerClass.defineAnnotatedMethods(Pointer.class);
        pointerClass.defineAnnotatedConstants(Pointer.class);
        pointerClass.setReifiedClass(Pointer.class);
        pointerClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof Pointer && super.isKindOf(obj, type2);
            }
        };
        module.defineClassUnder("NullPointerError", runtime2.getRuntimeError(), runtime2.getRuntimeError().getAllocator());
        Pointer nullPointer = new Pointer(runtime2, pointerClass, new NullMemoryIO(runtime2));
        pointerClass.setConstant("NULL", nullPointer);
        runtime2.getNilClass().addMethod("to_ptr", new NilToPointerMethod((RubyModule)runtime2.getNilClass(), nullPointer, "to_ptr"));
        return pointerClass;
    }

    public static final Pointer getNull(Ruby runtime2) {
        return runtime2.getFFI().nullPointer;
    }

    public Pointer(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz, runtime2.getFFI().getNullMemoryIO(), 0L);
    }

    public Pointer(Ruby runtime2, MemoryIO io2) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2);
    }

    public Pointer(Ruby runtime2, MemoryIO io2, long size2, int typeSize) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2, size2, typeSize);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, MemoryIO io2) {
        super(runtime2, klass, io2, Long.MAX_VALUE);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, MemoryIO io2, long size2) {
        super(runtime2, klass, io2, size2);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, MemoryIO io2, long size2, int typeSize) {
        super(runtime2, klass, io2, size2, typeSize);
    }

    public static final RubyClass getPointerClass(Ruby runtime2) {
        return runtime2.getFFI().pointerClass;
    }

    @Override
    public final AbstractMemory order(Ruby runtime2, ByteOrder order2) {
        return new Pointer(runtime2, order2.equals(this.getMemoryIO().order()) ? this.getMemoryIO() : new SwappedMemoryIO(runtime2, this.getMemoryIO()), this.size, this.typeSize);
    }

    @JRubyMethod(name={"size"}, meta=true, visibility=Visibility.PUBLIC)
    public static IRubyObject size(ThreadContext context, IRubyObject recv2) {
        return RubyFixnum.newFixnum(context.getRuntime(), Factory.getInstance().sizeOf(NativeType.POINTER));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject address2) {
        this.setMemoryIO(address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.runtime, RubyFixnum.num2long(address2)));
        this.size = Long.MAX_VALUE;
        this.typeSize = 1;
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject address2) {
        this.setMemoryIO(address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.runtime, RubyFixnum.num2long(address2)));
        this.size = Long.MAX_VALUE;
        this.typeSize = Pointer.calculateTypeSize(context, type2);
        return this;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        Pointer orig = (Pointer)other;
        this.typeSize = orig.typeSize;
        this.size = orig.size;
        this.setMemoryIO(orig.getMemoryIO().dup());
        return this;
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.runtime.newBoolean(this.getMemoryIO().isNull());
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        String s2 = this.size != Long.MAX_VALUE ? String.format("#<%s address=0x%x size=%s>", this.getMetaClass().getName(), this.getAddress(), this.size) : String.format("#<%s address=0x%x>", this.getMetaClass().getName(), this.getAddress());
        return RubyString.newString(context.runtime, s2);
    }

    @JRubyMethod(name={"address", "to_i"})
    public IRubyObject address(ThreadContext context) {
        return context.runtime.newFixnum(this.getAddress());
    }

    public final long getAddress() {
        return this.getMemoryIO().address();
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this == obj || this.getAddress() == 0L && obj.isNil() || obj instanceof Pointer && ((Pointer)obj).getAddress() == this.getAddress());
    }

    @Override
    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), this.getMemoryIO().slice(offset2), this.size == Long.MAX_VALUE ? Long.MAX_VALUE : this.size - offset2, this.typeSize);
    }

    @Override
    protected AbstractMemory slice(Ruby runtime2, long offset2, long size2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), this.getMemoryIO().slice(offset2, size2), size2, this.typeSize);
    }

    @Override
    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), this.getMemoryIO().getMemoryIO(offset2), Long.MAX_VALUE);
    }

    private static final class NilToPointerMethod
    extends DynamicMethod {
        private static final Arity ARITY = Arity.NO_ARGUMENTS;
        private final Pointer nullPointer;

        private NilToPointerMethod(RubyModule implementationClass, Pointer nullPointer, String name2) {
            super(implementationClass, Visibility.PUBLIC, name2);
            this.nullPointer = nullPointer;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            ARITY.checkArity(context.runtime, args2);
            return this.nullPointer;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
            return this.nullPointer;
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }
    }

    private static final class PointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new PointerAllocator();

        private PointerAllocator() {
        }

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new Pointer(runtime2, klazz);
        }
    }
}

