/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.SwapMeter;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class SwapTimer
extends SwapMeter<Timer>
implements Timer {
    SwapTimer(Registry registry, Id id, Timer underlying) {
        super(registry, id, underlying);
    }

    @Override
    public Timer lookup() {
        return this.registry.timer(this.id);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        ((Timer)this.get()).record(amount, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.registry.clock().monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.registry.clock().monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.registry.clock().monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.registry.clock().monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return ((Timer)this.get()).count();
    }

    @Override
    public long totalTime() {
        return ((Timer)this.get()).totalTime();
    }
}

