/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.builder;

import io.github.swagger2markup.Swagger2MarkupExtensionRegistry;
import io.github.swagger2markup.spi.DefinitionsDocumentExtension;
import io.github.swagger2markup.spi.OverviewDocumentExtension;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.github.swagger2markup.spi.SecurityDocumentExtension;
import io.github.swagger2markup.spi.SwaggerModelExtension;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.collections4.IteratorUtils;

public class Swagger2MarkupExtensionRegistryBuilder {
    private final Context context;

    public Swagger2MarkupExtensionRegistryBuilder() {
        List swaggerModelExtensions = IteratorUtils.toList(ServiceLoader.load(SwaggerModelExtension.class).iterator());
        List overviewDocumentExtensions = IteratorUtils.toList(ServiceLoader.load(OverviewDocumentExtension.class).iterator());
        List definitionsDocumentExtensions = IteratorUtils.toList(ServiceLoader.load(DefinitionsDocumentExtension.class).iterator());
        List pathsDocumentExtensions = IteratorUtils.toList(ServiceLoader.load(PathsDocumentExtension.class).iterator());
        List securityDocumentExtensions = IteratorUtils.toList(ServiceLoader.load(SecurityDocumentExtension.class).iterator());
        this.context = new Context(swaggerModelExtensions, overviewDocumentExtensions, definitionsDocumentExtensions, pathsDocumentExtensions, securityDocumentExtensions);
    }

    public Swagger2MarkupExtensionRegistry build() {
        return new DefaultSwagger2MarkupExtensionRegistry(this.context);
    }

    public Swagger2MarkupExtensionRegistryBuilder withSwaggerModelExtension(SwaggerModelExtension extension) {
        this.context.swaggerModelExtensions.add(extension);
        return this;
    }

    public Swagger2MarkupExtensionRegistryBuilder withOverviewDocumentExtension(OverviewDocumentExtension extension) {
        this.context.overviewDocumentExtensions.add(extension);
        return this;
    }

    public Swagger2MarkupExtensionRegistryBuilder withDefinitionsDocumentExtension(DefinitionsDocumentExtension extension) {
        this.context.definitionsDocumentExtensions.add(extension);
        return this;
    }

    public Swagger2MarkupExtensionRegistryBuilder withPathsDocumentExtension(PathsDocumentExtension extension) {
        this.context.pathsDocumentExtensions.add(extension);
        return this;
    }

    public Swagger2MarkupExtensionRegistryBuilder withSecurityDocumentExtension(SecurityDocumentExtension extension) {
        this.context.securityDocumentExtensions.add(extension);
        return this;
    }

    private static class Context {
        public final List<SwaggerModelExtension> swaggerModelExtensions;
        public final List<OverviewDocumentExtension> overviewDocumentExtensions;
        public final List<DefinitionsDocumentExtension> definitionsDocumentExtensions;
        public final List<PathsDocumentExtension> pathsDocumentExtensions;
        public final List<SecurityDocumentExtension> securityDocumentExtensions;

        public Context(List<SwaggerModelExtension> swaggerModelExtensions, List<OverviewDocumentExtension> overviewDocumentExtensions, List<DefinitionsDocumentExtension> definitionsDocumentExtensions, List<PathsDocumentExtension> pathsDocumentExtensions, List<SecurityDocumentExtension> securityDocumentExtensions) {
            this.swaggerModelExtensions = swaggerModelExtensions;
            this.overviewDocumentExtensions = overviewDocumentExtensions;
            this.definitionsDocumentExtensions = definitionsDocumentExtensions;
            this.pathsDocumentExtensions = pathsDocumentExtensions;
            this.securityDocumentExtensions = securityDocumentExtensions;
        }
    }

    static class DefaultSwagger2MarkupExtensionRegistry
    implements Swagger2MarkupExtensionRegistry {
        private Context context;

        DefaultSwagger2MarkupExtensionRegistry(Context context) {
            this.context = context;
        }

        @Override
        public List<SwaggerModelExtension> getSwaggerModelExtensions() {
            return this.context.swaggerModelExtensions;
        }

        @Override
        public List<OverviewDocumentExtension> getOverviewDocumentExtensions() {
            return this.context.overviewDocumentExtensions;
        }

        @Override
        public List<DefinitionsDocumentExtension> getDefinitionsDocumentExtensions() {
            return this.context.definitionsDocumentExtensions;
        }

        @Override
        public List<SecurityDocumentExtension> getSecurityDocumentExtensions() {
            return this.context.securityDocumentExtensions;
        }

        @Override
        public List<PathsDocumentExtension> getPathsDocumentExtensions() {
            return this.context.pathsDocumentExtensions;
        }
    }
}

