/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.MultiThreadDispatcher;
import reactor.core.support.NamedDaemonThreadFactory;

public class ThreadPoolExecutorDispatcher
extends MultiThreadDispatcher {
    private final ExecutorService executor;
    private final BlockingQueue<Runnable> workQueue;

    public ThreadPoolExecutorDispatcher(int poolSize, int backlog) {
        this(poolSize, backlog, "threadPoolExecutorDispatcher");
    }

    public ThreadPoolExecutorDispatcher(int poolSize, int backlog, String threadName) {
        this(poolSize, backlog, threadName, new LinkedBlockingQueue<Runnable>(backlog), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                r.run();
            }
        });
    }

    public ThreadPoolExecutorDispatcher(int poolSize, int backlog, String threadName, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(poolSize, backlog);
        this.workQueue = workQueue;
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, workQueue, new NamedDaemonThreadFactory(threadName, this.getContext()), rejectedExecutionHandler);
    }

    public ThreadPoolExecutorDispatcher(int backlog, int poolSize, ExecutorService executor) {
        super(poolSize, backlog);
        this.executor = executor;
        this.workQueue = null;
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            if (!this.executor.awaitTermination(timeout, timeUnit)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void forceShutdown() {
        this.executor.shutdownNow();
        super.forceShutdown();
    }

    @Override
    public long remainingSlots() {
        return this.workQueue != null ? (long)this.workQueue.remainingCapacity() : Long.MAX_VALUE;
    }

    @Override
    protected void execute(AbstractLifecycleDispatcher.Task task) {
        this.executor.execute(task);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }
}

