/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import io.swagger.annotations.ApiOperation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.context.InvocationContextCompletableFuture;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.springframework.util.StringUtils;

public class Invoker
implements InvocationHandler {
    protected String microserviceName;
    protected String schemaId;
    protected Class<?> consumerIntf;
    protected InvokerMeta invokerMeta = new InvokerMeta(null, null, null, null);

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.microserviceName = microserviceName;
        this.schemaId = schemaId;
        this.consumerIntf = consumerIntf;
    }

    protected InvokerMeta createInvokerMeta() {
        SchemaMeta schemaMeta;
        ReferenceConfig referenceConfig = this.findReferenceConfig();
        MicroserviceMeta microserviceMeta = referenceConfig.getMicroserviceMeta();
        if (StringUtils.isEmpty((Object)this.schemaId)) {
            schemaMeta = microserviceMeta.findSchemaMeta(this.consumerIntf);
            if (schemaMeta == null) {
                schemaMeta = microserviceMeta.findSchemaMeta(this.consumerIntf.getName());
            }
        } else {
            schemaMeta = microserviceMeta.findSchemaMeta(this.schemaId);
        }
        if (schemaMeta == null) {
            throw new IllegalStateException(String.format("Schema not exist, microserviceName=%s, schemaId=%s, consumer interface=%s; new producer not running or not deployed.", this.microserviceName, StringUtils.isEmpty((Object)this.schemaId) ? "" : this.schemaId, this.consumerIntf.getName()));
        }
        SwaggerConsumer swaggerConsumer = CseContext.getInstance().getSwaggerEnvironment().createConsumer(this.consumerIntf, schemaMeta.getSwaggerIntf());
        return new InvokerMeta(referenceConfig, microserviceMeta, schemaMeta, swaggerConsumer);
    }

    protected ReferenceConfig findReferenceConfig() {
        return SCBEngine.getInstance().getReferenceConfigForInvoke(this.microserviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        SwaggerConsumerOperation consumerOperation;
        InvokerMeta currentInvokerMeta = this.invokerMeta;
        if (!currentInvokerMeta.isValid()) {
            Invoker invoker = this;
            synchronized (invoker) {
                currentInvokerMeta = this.invokerMeta;
                if (!currentInvokerMeta.isValid()) {
                    currentInvokerMeta = this.invokerMeta = this.createInvokerMeta();
                }
            }
        }
        if ((consumerOperation = currentInvokerMeta.swaggerConsumer.findOperation(this.findSwaggerMethodName(method))) == null) {
            throw new IllegalStateException(String.format("Consumer method %s:%s not exist in contract, microserviceName=%s, schemaId=%s; new producer not running or not deployed.", this.consumerIntf.getName(), method.getName(), this.microserviceName, this.schemaId));
        }
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)currentInvokerMeta.referenceConfig, (SchemaMeta)currentInvokerMeta.schemaMeta, (String)consumerOperation.getSwaggerMethod().getName(), null);
        consumerOperation.getArgumentsMapper().toInvocation(args, (SwaggerInvocation)invocation);
        if (CompletableFuture.class.equals(method.getReturnType())) {
            return this.completableFutureInvoke(invocation, consumerOperation);
        }
        return this.syncInvoke(invocation, consumerOperation);
    }

    protected String findSwaggerMethodName(Method consumerMethod) {
        ApiOperation apiOperationAnnotation = consumerMethod.getAnnotation(ApiOperation.class);
        if (apiOperationAnnotation == null || StringUtils.isEmpty((Object)apiOperationAnnotation.nickname())) {
            return consumerMethod.getName();
        }
        return apiOperationAnnotation.nickname();
    }

    protected Object syncInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        Response response = InvokerUtils.innerSyncInvoke((Invocation)invocation);
        if (response.isSucceed()) {
            return consumerOperation.getResponseMapper().mapResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected CompletableFuture<Object> completableFutureInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        InvocationContextCompletableFuture future = new InvocationContextCompletableFuture((InvocationContext)invocation);
        InvokerUtils.reactiveInvoke((Invocation)invocation, arg_0 -> Invoker.lambda$completableFutureInvoke$0(consumerOperation, (CompletableFuture)future, arg_0));
        return future;
    }

    private static /* synthetic */ void lambda$completableFutureInvoke$0(SwaggerConsumerOperation consumerOperation, CompletableFuture future, Response response) {
        if (response.isSucceed()) {
            Object result = consumerOperation.getResponseMapper().mapResponse(response);
            future.complete(result);
            return;
        }
        future.completeExceptionally((Throwable)response.getResult());
    }

    static class InvokerMeta {
        final ReferenceConfig referenceConfig;
        final MicroserviceMeta microserviceMeta;
        final SchemaMeta schemaMeta;
        final SwaggerConsumer swaggerConsumer;

        public InvokerMeta(ReferenceConfig referenceConfig, MicroserviceMeta microserviceMeta, SchemaMeta schemaMeta, SwaggerConsumer swaggerConsumer) {
            this.referenceConfig = referenceConfig;
            this.microserviceMeta = microserviceMeta;
            this.schemaMeta = schemaMeta;
            this.swaggerConsumer = swaggerConsumer;
        }

        public boolean isValid() {
            SCBEngine.getInstance().ensureStatusUp();
            return this.swaggerConsumer != null && this.microserviceMeta == this.referenceConfig.getMicroserviceMeta();
        }
    }
}

