/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo.http.websocket;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitors;
import io.reactivex.netty.metrics.WebSocketServerMetricEventsListener;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerMetricsEvent;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.servo.ServoUtils;
import io.reactivex.netty.servo.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;

public class WebSocketServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final LongGauge processedHandshakes;
    private final LongGauge failedHandshakes;
    private final Counter webSocketWrites;
    private final Counter getWebSocketReads;
    private final WebSocketServerMetricEventsListenerImpl delegate = new WebSocketServerMetricEventsListenerImpl();

    protected WebSocketServerListener(String monitorId) {
        super(monitorId);
        this.processedHandshakes = ServoUtils.newLongGauge("processedHandshakes");
        this.failedHandshakes = ServoUtils.newLongGauge("failedHandshakes");
        this.webSocketWrites = Monitors.newCounter((String)"webSocketWrites");
        this.getWebSocketReads = Monitors.newCounter((String)"getWebSocketReads");
    }

    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType().getClass() == WebSocketServerMetricsEvent.EventType.class) {
            this.delegate.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            super.onEvent(event, duration, timeUnit, throwable, value);
        }
    }

    public long getProcessedHandshakes() {
        return this.processedHandshakes.getNumber().get();
    }

    public long getFailedHandshakes() {
        return ((Number)this.failedHandshakes.getValue()).longValue();
    }

    public long getWebSocketWrites() {
        return ((Number)this.webSocketWrites.getValue()).longValue();
    }

    public long getWebSocketReads() {
        return ((Number)this.getWebSocketReads.getValue()).longValue();
    }

    public static WebSocketServerListener newWebSocketListener(String monitorId) {
        return new WebSocketServerListener(monitorId);
    }

    private class WebSocketServerMetricEventsListenerImpl
    extends WebSocketServerMetricEventsListener {
        private WebSocketServerMetricEventsListenerImpl() {
        }

        protected void onHandshakeProcessed() {
            ServoUtils.incrementLongGauge(WebSocketServerListener.this.processedHandshakes);
        }

        protected void onHandshakeFailure() {
            ServoUtils.incrementLongGauge(WebSocketServerListener.this.processedHandshakes);
            ServoUtils.incrementLongGauge(WebSocketServerListener.this.failedHandshakes);
        }

        protected void onWebSocketWrites() {
            WebSocketServerListener.this.webSocketWrites.increment();
        }

        protected void onWebSocketReads() {
            WebSocketServerListener.this.getWebSocketReads.increment();
        }
    }
}

