/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;

public class CookieItem
implements AccessLogItem<RoutingContext> {
    public static final String RESULT_NOT_FOUND = "-";
    private final String varName;

    public CookieItem(String varName) {
        this.varName = varName;
    }

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        Set cookieSet = accessLogParam.getContextData().cookies();
        if (null == cookieSet) {
            return RESULT_NOT_FOUND;
        }
        String result = null;
        for (Cookie cookie : cookieSet) {
            if (!this.varName.equals(cookie.getName())) continue;
            result = cookie.getValue();
        }
        if (null == result) {
            return RESULT_NOT_FOUND;
        }
        return result;
    }

    public String getVarName() {
        return this.varName;
    }
}

