/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.Component;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.BufferNextMessage;
import zipkin2.reporter.ByteBoundedQueue;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SpanWithSizeConsumer;

public abstract class AsyncReporter<S>
extends Component
implements Reporter<S>,
Flushable {
    public static AsyncReporter<Span> create(Sender sender) {
        return new Builder(sender).build();
    }

    public static Builder builder(Sender sender) {
        return new Builder(sender);
    }

    @Override
    public abstract void flush();

    public abstract void close();

    static final class BoundedAsyncReporter<S>
    extends AsyncReporter<S> {
        static final Logger logger = Logger.getLogger(BoundedAsyncReporter.class.getName());
        final AtomicBoolean closed = new AtomicBoolean(false);
        final BytesEncoder<S> encoder;
        final ByteBoundedQueue<S> pending;
        final Sender sender;
        final int messageMaxBytes;
        final long messageTimeoutNanos;
        final long closeTimeoutNanos;
        final CountDownLatch close;
        final ReporterMetrics metrics;

        BoundedAsyncReporter(Builder builder, BytesEncoder<S> encoder) {
            this.pending = new ByteBoundedQueue(builder.queuedMaxSpans, builder.queuedMaxBytes);
            this.sender = builder.sender;
            this.messageMaxBytes = builder.messageMaxBytes;
            this.messageTimeoutNanos = builder.messageTimeoutNanos;
            this.closeTimeoutNanos = builder.closeTimeoutNanos;
            this.close = new CountDownLatch(builder.messageTimeoutNanos > 0L ? 1 : 0);
            this.metrics = builder.metrics;
            this.encoder = encoder;
        }

        @Override
        public void report(S next) {
            if (next == null) {
                throw new NullPointerException("span == null");
            }
            this.metrics.incrementSpans(1);
            int nextSizeInBytes = this.encoder.sizeInBytes(next);
            int messageSizeOfNextSpan = this.sender.messageSizeInBytes(nextSizeInBytes);
            this.metrics.incrementSpanBytes(nextSizeInBytes);
            if (this.closed.get() || messageSizeOfNextSpan > this.messageMaxBytes || !this.pending.offer(next, nextSizeInBytes)) {
                this.metrics.incrementSpansDropped(1);
            }
        }

        @Override
        public final void flush() {
            this.flush(BufferNextMessage.create(this.encoder.encoding(), this.messageMaxBytes, 0L));
        }

        void flush(BufferNextMessage<S> bundler) {
            block5: {
                if (this.closed.get()) {
                    throw new IllegalStateException("closed");
                }
                this.pending.drainTo(bundler, bundler.remainingNanos());
                this.metrics.updateQueuedSpans(this.pending.count);
                this.metrics.updateQueuedBytes(this.pending.sizeInBytes);
                if (!bundler.isReady() && !this.closed.get()) {
                    return;
                }
                this.metrics.incrementMessages();
                this.metrics.incrementMessageBytes(bundler.sizeInBytes());
                final ArrayList<byte[]> nextMessage = new ArrayList<byte[]>(bundler.count());
                bundler.drain(new SpanWithSizeConsumer<S>(){

                    @Override
                    public boolean offer(S next, int nextSizeInBytes) {
                        nextMessage.add(BoundedAsyncReporter.this.encoder.encode(next));
                        if (BoundedAsyncReporter.this.sender.messageSizeInBytes(nextMessage) > BoundedAsyncReporter.this.messageMaxBytes) {
                            nextMessage.remove(nextMessage.size() - 1);
                            return false;
                        }
                        return true;
                    }
                });
                try {
                    this.sender.sendSpans(nextMessage).execute();
                }
                catch (IOException | Error | RuntimeException t) {
                    int count = nextMessage.size();
                    Call.propagateIfFatal((Throwable)t);
                    this.metrics.incrementMessagesDropped(t);
                    this.metrics.incrementSpansDropped(count);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, String.format("Dropped %s spans due to %s(%s)", count, t.getClass().getSimpleName(), t.getMessage() == null ? "" : t.getMessage()), t);
                    }
                    if (!(t instanceof IllegalStateException)) break block5;
                    throw (IllegalStateException)t;
                }
            }
        }

        public CheckResult check() {
            return this.sender.check();
        }

        @Override
        public void close() {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (!this.close.await(this.closeTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    logger.warning("Timed out waiting for in-flight spans to send");
                }
            }
            catch (InterruptedException e) {
                logger.warning("Interrupted waiting for in-flight spans to send");
                Thread.currentThread().interrupt();
            }
            int count = this.pending.clear();
            if (count > 0) {
                this.metrics.incrementSpansDropped(count);
                logger.warning("Dropped " + count + " spans due to AsyncReporter.close()");
            }
        }

        public String toString() {
            return "AsyncReporter{" + (Object)((Object)this.sender) + "}";
        }
    }

    public static final class Builder {
        final Sender sender;
        ReporterMetrics metrics = ReporterMetrics.NOOP_METRICS;
        int messageMaxBytes;
        long messageTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        long closeTimeoutNanos = TimeUnit.SECONDS.toNanos(1L);
        int queuedMaxSpans = 10000;
        int queuedMaxBytes = Builder.onePercentOfMemory();

        static int onePercentOfMemory() {
            long result = (long)((double)Runtime.getRuntime().totalMemory() * 0.01);
            return (int)Math.max(Math.min(Integer.MAX_VALUE, result), Integer.MIN_VALUE);
        }

        Builder(Sender sender) {
            if (sender == null) {
                throw new NullPointerException("sender == null");
            }
            this.sender = sender;
            this.messageMaxBytes = sender.messageMaxBytes();
        }

        public Builder metrics(ReporterMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            if (messageMaxBytes < 0) {
                throw new IllegalArgumentException("messageMaxBytes < 0: " + messageMaxBytes);
            }
            this.messageMaxBytes = Math.min(messageMaxBytes, this.sender.messageMaxBytes());
            return this;
        }

        public Builder messageTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("messageTimeout < 0: " + timeout);
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            this.messageTimeoutNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder closeTimeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("closeTimeout < 0: " + timeout);
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            this.closeTimeoutNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder queuedMaxSpans(int queuedMaxSpans) {
            this.queuedMaxSpans = queuedMaxSpans;
            return this;
        }

        public Builder queuedMaxBytes(int queuedMaxBytes) {
            this.queuedMaxBytes = queuedMaxBytes;
            return this;
        }

        public AsyncReporter<Span> build() {
            switch (this.sender.encoding()) {
                case JSON: {
                    return this.build((BytesEncoder)SpanBytesEncoder.JSON_V2);
                }
            }
            throw new UnsupportedOperationException(this.sender.encoding().name());
        }

        public <S> AsyncReporter<S> build(BytesEncoder<S> encoder) {
            if (encoder == null) {
                throw new NullPointerException("encoder == null");
            }
            if (encoder.encoding() != this.sender.encoding()) {
                throw new IllegalArgumentException(String.format("Encoder doesn't match Sender: %s %s", encoder.encoding(), this.sender.encoding()));
            }
            final BoundedAsyncReporter<S> result = new BoundedAsyncReporter<S>(this, encoder);
            if (this.messageTimeoutNanos > 0L) {
                final BufferNextMessage consumer = BufferNextMessage.create(encoder.encoding(), this.messageMaxBytes, this.messageTimeoutNanos);
                Thread flushThread = new Thread("AsyncReporter{" + (Object)((Object)this.sender) + "}"){

                    @Override
                    public void run() {
                        try {
                            while (!result.closed.get()) {
                                result.flush(consumer);
                            }
                        }
                        finally {
                            int count = consumer.count();
                            if (count > 0) {
                                Builder.this.metrics.incrementSpansDropped(count);
                                BoundedAsyncReporter.logger.warning("Dropped " + count + " spans due to AsyncReporter.close()");
                            }
                            result.close.countDown();
                        }
                    }
                };
                flushThread.setDaemon(true);
                flushThread.start();
            }
            return result;
        }
    }
}

