/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.metric.HystrixEvent;
import com.netflix.hystrix.metric.HystrixEventStream;
import com.netflix.hystrix.metric.consumer.BucketedCounterStream;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func2;

public abstract class BucketedCumulativeCounterStream<Event extends HystrixEvent, Bucket, Output>
extends BucketedCounterStream<Event, Bucket, Output> {
    private Observable<Output> sourceStream;
    private final AtomicBoolean isSourceCurrentlySubscribed = new AtomicBoolean(false);

    protected BucketedCumulativeCounterStream(HystrixEventStream<Event> stream, int numBuckets, int bucketSizeInMs, Func2<Bucket, Event, Bucket> reduceCommandCompletion, Func2<Output, Bucket, Output> reduceBucket) {
        super(stream, numBuckets, bucketSizeInMs, reduceCommandCompletion);
        this.sourceStream = this.bucketedStream.scan(this.getEmptyOutputValue(), reduceBucket).skip(numBuckets).doOnSubscribe(new Action0(){

            public void call() {
                BucketedCumulativeCounterStream.this.isSourceCurrentlySubscribed.set(true);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                BucketedCumulativeCounterStream.this.isSourceCurrentlySubscribed.set(false);
            }
        }).share().onBackpressureDrop();
    }

    @Override
    public Observable<Output> observe() {
        return this.sourceStream;
    }
}

