/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.adapter.ParameterAdapter;
import io.github.swagger2markup.internal.component.PropertiesTableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class BodyParameterComponent
extends MarkupComponent<Parameters> {
    private final DocumentResolver definitionDocumentResolver;
    private final PropertiesTableComponent propertiesTableComponent;

    public BodyParameterComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionDocumentResolver) {
        super(context);
        this.definitionDocumentResolver = (DocumentResolver)Validate.notNull((Object)definitionDocumentResolver, (String)"DocumentResolver must not be null", (Object[])new Object[0]);
        this.propertiesTableComponent = new PropertiesTableComponent(context, definitionDocumentResolver);
    }

    public static Parameters parameters(PathOperation operation, List<ObjectType> inlineDefinitions) {
        return new Parameters(operation, inlineDefinitions);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        List parameters;
        PathOperation operation = params.operation;
        List inlineDefinitions = params.inlineDefinitions;
        if (this.config.isFlatBodyEnabled() && CollectionUtils.isNotEmpty((Collection)(parameters = operation.getOperation().getParameters()))) {
            for (Parameter parameter : parameters) {
                if (!StringUtils.equals((CharSequence)parameter.getIn(), (CharSequence)"body")) continue;
                ParameterAdapter parameterAdapter = new ParameterAdapter(this.context, operation, parameter, this.definitionDocumentResolver);
                Type type = parameterAdapter.getType();
                inlineDefinitions.addAll(parameterAdapter.getInlineDefinitions());
                this.buildSectionTitle(markupDocBuilder, this.labels.getLabel("body_parameter"));
                String description = parameter.getDescription();
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    markupDocBuilder.paragraph(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, description));
                }
                MarkupDocBuilder typeInfos = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
                typeInfos.italicText(this.labels.getLabel("name_column")).textLine(" : " + parameter.getName());
                typeInfos.italicText(this.labels.getLabel("flags.column")).textLine(" : " + (BooleanUtils.isTrue((Boolean)parameter.getRequired()) ? this.labels.getLabel("flags.required").toLowerCase() : this.labels.getLabel("flags.optional").toLowerCase()));
                if (!(type instanceof ObjectType)) {
                    typeInfos.italicText(this.labels.getLabel("type_column")).textLine(" : " + type.displaySchema(markupDocBuilder));
                }
                markupDocBuilder.paragraph(typeInfos.toString(), true);
                if (!(type instanceof ObjectType)) continue;
                ArrayList<ObjectType> localDefinitions = new ArrayList<ObjectType>();
                this.propertiesTableComponent.apply(markupDocBuilder, PropertiesTableComponent.parameters(((ObjectType)type).getProperties(), operation.getId(), localDefinitions));
                inlineDefinitions.addAll(localDefinitions);
            }
        }
        return markupDocBuilder;
    }

    private void buildSectionTitle(MarkupDocBuilder markupDocBuilder, String title) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            markupDocBuilder.sectionTitleLevel3(title);
        } else {
            markupDocBuilder.sectionTitleLevel4(title);
        }
    }

    public static class Parameters {
        private final List<ObjectType> inlineDefinitions;
        private PathOperation operation;

        public Parameters(PathOperation operation, List<ObjectType> inlineDefinitions) {
            Validate.notNull((Object)operation, (String)"Operation must not be null", (Object[])new Object[0]);
            this.operation = operation;
            this.inlineDefinitions = inlineDefinitions;
        }
    }
}

