/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import zipkin2.internal.Buffer;
import zipkin2.internal.JsonCodec;

final class Proto3Fields {
    static final int WIRETYPE_VARINT = 0;
    static final int WIRETYPE_FIXED64 = 1;
    static final int WIRETYPE_LENGTH_DELIMITED = 2;
    static final int WIRETYPE_FIXED32 = 5;

    Proto3Fields() {
    }

    static int sizeOfLengthDelimitedField(int sizeInBytes) {
        return 1 + Buffer.varintSizeInBytes(sizeInBytes) + sizeInBytes;
    }

    static void ensureLength(Buffer buffer, int length) {
        if (length > buffer.remaining()) {
            throw new IllegalArgumentException("Truncated: length " + length + " > bytes remaining " + buffer.remaining());
        }
    }

    static final class Fixed32Field
    extends Field {
        Fixed32Field(int key) {
            super(key);
            assert (this.wireType == 5);
        }

        int sizeInBytes(int number) {
            if (number == 0) {
                return 0;
            }
            return 5;
        }
    }

    static final class BooleanField
    extends Field {
        BooleanField(int key) {
            super(key);
            assert (this.wireType == 0);
        }

        int sizeInBytes(boolean bool) {
            return bool ? 2 : 0;
        }

        void write(Buffer b, boolean bool) {
            if (!bool) {
                return;
            }
            b.writeByte(this.key);
            b.writeByte(1);
        }

        boolean read(Buffer b) {
            byte bool = b.readByte();
            if (bool < 0 || bool > 1) {
                throw new IllegalArgumentException("Malformed: invalid boolean value at byte " + b.pos);
            }
            return bool == 1;
        }
    }

    static class VarintField
    extends Field {
        VarintField(int key) {
            super(key);
            assert (this.wireType == 0);
        }

        int sizeInBytes(int number) {
            return number != 0 ? 1 + Buffer.varintSizeInBytes(number) : 0;
        }

        void write(Buffer b, int number) {
            if (number == 0) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(number);
        }

        int sizeInBytes(long number) {
            return number != 0L ? 1 + Buffer.varintSizeInBytes(number) : 0;
        }

        void write(Buffer b, long number) {
            if (number == 0L) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(number);
        }
    }

    static final class Fixed64Field
    extends Field {
        Fixed64Field(int key) {
            super(key);
            assert (this.wireType == 1);
        }

        void write(Buffer b, long number) {
            if (number == 0L) {
                return;
            }
            b.writeByte(this.key);
            b.writeLongLe(number);
        }

        int sizeInBytes(long number) {
            if (number == 0L) {
                return 0;
            }
            return 9;
        }

        long readValue(Buffer buffer) {
            Proto3Fields.ensureLength(buffer, 8);
            return buffer.readLongLe();
        }
    }

    static class Utf8Field
    extends LengthDelimitedField<String> {
        Utf8Field(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(String utf8) {
            return utf8 != null ? Buffer.utf8SizeInBytes(utf8) : 0;
        }

        @Override
        void writeValue(Buffer b, String utf8) {
            b.writeUtf8(utf8);
        }

        @Override
        String readValue(Buffer buffer, int length) {
            String result = new String(buffer.toByteArray(), buffer.pos, length, JsonCodec.UTF_8);
            buffer.pos += length;
            return result;
        }
    }

    static class HexField
    extends LengthDelimitedField<String> {
        static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        HexField(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(String hex) {
            if (hex == null) {
                return 0;
            }
            return hex.length() / 2;
        }

        @Override
        void writeValue(Buffer b, String hex) {
            int length = hex.length();
            for (int i = 0; i < length; ++i) {
                int d1 = HexField.decodeLowerHex(hex.charAt(i++)) << 4;
                int d2 = HexField.decodeLowerHex(hex.charAt(i));
                b.writeByte((byte)(d1 + d2));
            }
        }

        static int decodeLowerHex(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            throw new AssertionError((Object)("not lowerHex " + c));
        }

        @Override
        String readValue(Buffer buffer, int length) {
            char[] result = new char[length *= 2];
            for (int i = 0; i < length; i += 2) {
                byte b = buffer.readByte();
                result[i + 0] = HEX_DIGITS[b >> 4 & 0xF];
                result[i + 1] = HEX_DIGITS[b & 0xF];
            }
            return new String(result);
        }
    }

    static class BytesField
    extends LengthDelimitedField<byte[]> {
        BytesField(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(byte[] bytes) {
            return bytes.length;
        }

        @Override
        void writeValue(Buffer b, byte[] bytes) {
            b.write(bytes);
        }

        @Override
        byte[] readValue(Buffer b, int length) {
            byte[] result = new byte[length];
            System.arraycopy(b.toByteArray(), b.pos, result, 0, length);
            b.pos += length;
            return result;
        }
    }

    static abstract class LengthDelimitedField<T>
    extends Field {
        LengthDelimitedField(int key) {
            super(key);
            assert (this.wireType == 2);
        }

        final int sizeInBytes(T value) {
            if (value == null) {
                return 0;
            }
            int sizeOfValue = this.sizeOfValue(value);
            if (sizeOfValue == 0) {
                return 0;
            }
            return Proto3Fields.sizeOfLengthDelimitedField(sizeOfValue);
        }

        final void write(Buffer b, T value) {
            if (value == null) {
                return;
            }
            int sizeOfValue = this.sizeOfValue(value);
            if (sizeOfValue == 0) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(sizeOfValue);
            this.writeValue(b, value);
        }

        final T readLengthPrefixAndValue(Buffer b) {
            int length = this.readLengthPrefix(b);
            if (length == 0) {
                return null;
            }
            return this.readValue(b, length);
        }

        final int readLengthPrefix(Buffer b) {
            int length = b.readVarint32();
            Proto3Fields.ensureLength(b, length);
            return length;
        }

        abstract int sizeOfValue(T var1);

        abstract void writeValue(Buffer var1, T var2);

        abstract T readValue(Buffer var1, int var2);
    }

    static class Field {
        final int fieldNumber;
        final int wireType;
        final int key;

        Field(int key) {
            this(key >>> 3, key & 7, key);
        }

        Field(int fieldNumber, int wireType, int key) {
            this.fieldNumber = fieldNumber;
            this.wireType = wireType;
            this.key = key;
        }

        static int fieldNumber(int key, int byteL) {
            int fieldNumber = key >>> 3;
            if (fieldNumber != 0) {
                return fieldNumber;
            }
            throw new IllegalArgumentException("Malformed: fieldNumber was zero at byte " + byteL);
        }

        static int wireType(int key, int byteL) {
            int wireType = key & 7;
            if (wireType != 0 && wireType != 1 && wireType != 2 && wireType != 5) {
                throw new IllegalArgumentException("Malformed: invalid wireType " + wireType + " at byte " + byteL);
            }
            return wireType;
        }

        static boolean skipValue(Buffer buffer, int wireType) {
            int remaining = buffer.remaining();
            switch (wireType) {
                case 0: {
                    for (int i = 0; i < remaining; ++i) {
                        if (buffer.readByte() < 0) continue;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    return buffer.skip(8);
                }
                case 2: {
                    int length = buffer.readVarint32();
                    return buffer.skip(length);
                }
                case 5: {
                    return buffer.skip(4);
                }
            }
            throw new IllegalArgumentException("Malformed: invalid wireType " + wireType + " at byte " + buffer.pos);
        }
    }
}

