/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.ints;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class Int32PackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new Int32PackedWriters(protoField));
    }

    private static class Int32PackedWriters
    extends AbstractPrimitiveWriters<int[], Integer> {
        public Int32PackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (int element : array) {
                    output.writePackedInt32(element);
                }
            });
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Integer element : array) {
                    if (element != null) {
                        output.writePackedInt32(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                for (Integer element : collection) {
                    if (element != null) {
                        output.writePackedInt32(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        int parsedValue = Integer.parseInt(element, 10);
                        output.writePackedInt32(parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
        }
    }
}

