/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class AsyncResolveConnectHelper {
    private List<Handler<AsyncResult<Channel>>> handlers = new ArrayList<Handler<AsyncResult<Channel>>>();
    private ChannelFuture future;
    private AsyncResult<Channel> result;

    public synchronized void addListener(Handler<AsyncResult<Channel>> handler) {
        if (this.result != null) {
            if (this.future != null) {
                this.future.addListener(v -> handler.handle(this.result));
            } else {
                handler.handle(this.result);
            }
        } else {
            this.handlers.add(handler);
        }
    }

    private synchronized void handle(ChannelFuture cf, AsyncResult<Channel> res) {
        if (this.result == null) {
            for (Handler<AsyncResult<Channel>> handler : this.handlers) {
                handler.handle(res);
            }
        } else {
            throw new IllegalStateException("Already complete!");
        }
        this.future = cf;
        this.result = res;
    }

    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
    }

    public static AsyncResolveConnectHelper doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        AsyncResolveConnectHelper asyncResolveConnectHelper = new AsyncResolveConnectHelper();
        bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.path() != null));
        if (socketAddress.path() != null) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress, true);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener(f -> {
                if (f.isSuccess()) {
                    asyncResolveConnectHelper.handle(future, Future.succeededFuture(future.channel()));
                } else {
                    asyncResolveConnectHelper.handle(future, Future.failedFuture(f.cause()));
                }
            });
        } else {
            AsyncResolveConnectHelper.checkPort(socketAddress.port());
            vertx.resolveAddress(socketAddress.host(), res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind((java.net.SocketAddress)t);
                    future.addListener(f -> {
                        if (f.isSuccess()) {
                            asyncResolveConnectHelper.handle(future, Future.succeededFuture(future.channel()));
                        } else {
                            asyncResolveConnectHelper.handle(future, Future.failedFuture(f.cause()));
                        }
                    });
                } else {
                    asyncResolveConnectHelper.handle(null, Future.failedFuture(res.cause()));
                }
            });
        }
        return asyncResolveConnectHelper;
    }
}

