/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import io.vavr.collection.Map;
import java.util.Arrays;
import java.util.stream.DoubleStream;

public final class DoubleColumn
implements Column<ColumnIds.DoubleColumnId> {
    private final ColumnIds.DoubleColumnId id;
    private final double[] values;
    private final Map<String, String> metaData;

    private DoubleColumn(ColumnIds.DoubleColumnId id, DoubleStream values, Map<String, String> metaData) {
        this.id = id;
        this.values = values.toArray();
        this.metaData = metaData;
    }

    public static DoubleColumn of(ColumnIds.DoubleColumnId id, double value) {
        return DoubleColumn.builder(id).add(value).build();
    }

    public static DoubleColumn ofAll(ColumnIds.DoubleColumnId id, double ... values) {
        return DoubleColumn.builder(id).addAll(values).build();
    }

    public static DoubleColumn ofAll(ColumnIds.DoubleColumnId id, DoubleStream values) {
        return DoubleColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.DoubleColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.DoubleColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public DoubleStream valueStream() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<Double, DoubleColumn> {
        private final ColumnIds.DoubleColumnId id;
        private final DoubleStream.Builder valueBuilder;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.DoubleColumnId id) {
            this.id = id;
            this.valueBuilder = DoubleStream.builder();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(Double value) {
            this.valueBuilder.add(value);
            return this;
        }

        public Builder addAll(double ... values) {
            return this.addAll(Arrays.stream(values));
        }

        public Builder addAll(DoubleStream values) {
            values.forEachOrdered(this::add);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public DoubleColumn build() {
            return new DoubleColumn(this.id, this.valueBuilder.build(), (Map)this.metaDataBuilder.build());
        }
    }
}

