/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.Info;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class VersionInfoComponent
extends MarkupComponent<Parameters> {
    public VersionInfoComponent(Swagger2MarkupConverter.Context context) {
        super(context);
    }

    public static Parameters parameters(Info info, int titleLevel) {
        return new Parameters(info, titleLevel);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        String version = params.info.getVersion();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("current_version"));
            MarkupDocBuilder paragraphBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
            paragraphBuilder.italicText(this.labels.getLabel("version")).textLine(" : " + version);
            markupDocBuilder.paragraph(paragraphBuilder.toString(), true);
        }
        return markupDocBuilder;
    }

    public static class Parameters {
        private final int titleLevel;
        private final Info info;

        public Parameters(Info info, int titleLevel) {
            this.info = (Info)Validate.notNull((Object)info, (String)"Info must not be null", (Object[])new Object[0]);
            this.titleLevel = titleLevel;
        }
    }
}

