/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;
import org.apache.servicecomb.foundation.common.part.FilePart;
import org.apache.servicecomb.foundation.common.part.InputStreamPart;
import org.apache.servicecomb.foundation.common.part.ResourcePart;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;
import org.springframework.core.io.Resource;

public class CommonToHttpServletRequest
extends AbstractHttpServletRequest {
    private Map<String, List<String>> queryParams;
    private Map<String, List<String>> httpHeaders;
    private List<String> fileKeys = new ArrayList<String>();
    private Cookie[] cookies;

    public CommonToHttpServletRequest(Map<String, String> pathParams, Map<String, List<String>> queryParams, Map<String, List<String>> httpHeaders, Object bodyObject, boolean isFormData, List<String> fileKeys) {
        this.setAttribute("servicecomb-paths", pathParams);
        this.fileKeys = fileKeys;
        if (isFormData) {
            this.setAttribute("servicecomb-forms", (Map)bodyObject);
        } else {
            this.setAttribute("servicecomb-body", bodyObject);
        }
        this.queryParams = queryParams;
        this.httpHeaders = httpHeaders;
    }

    public CommonToHttpServletRequest(Map<String, String> pathParams, Map<String, List<String>> queryParams, Map<String, List<String>> httpHeaders, Object bodyObject, boolean isFormData) {
        this(pathParams, queryParams, httpHeaders, bodyObject, isFormData, null);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getParameter(String name) {
        List<String> queryValues = this.queryParams.get(name);
        if (queryValues == null || queryValues.isEmpty()) {
            return null;
        }
        return queryValues.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> queryValues = this.queryParams.get(name);
        if (queryValues == null || queryValues.isEmpty()) {
            return null;
        }
        return queryValues.toArray(new String[queryValues.size()]);
    }

    public String getHeader(String name) {
        List<String> headerValues = this.httpHeaders.get(name);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> headerValues = this.httpHeaders.get(name);
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(headerValues);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.httpHeaders.keySet());
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = this.createCookies();
        }
        return this.cookies;
    }

    private Cookie[] createCookies() {
        List<String> strCookies = this.httpHeaders.get("Cookie");
        if (strCookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (String strCookie : strCookies) {
            List<HttpCookie> httpCookies = HttpCookie.parse(strCookie);
            for (HttpCookie httpCookie : httpCookies) {
                Cookie cookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
                result.add(cookie);
            }
        }
        return result.toArray(new Cookie[result.size()]);
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public void setHeader(String name, String value) {
        this.httpHeaders.put(name, Arrays.asList(value));
    }

    public void addHeader(String name, String value) {
        List list = this.httpHeaders.computeIfAbsent(name, key -> new ArrayList());
        list.add(value);
    }

    public Part getPart(String name) {
        Object value = this.findPartInputValue(name);
        return this.getSinglePart(name, value);
    }

    private Part getSinglePart(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (Part.class.isInstance(value)) {
            return (Part)value;
        }
        if (InputStream.class.isInstance(value)) {
            return new InputStreamPart(name, (InputStream)value);
        }
        if (Resource.class.isInstance(value)) {
            return new ResourcePart(name, (Resource)value);
        }
        if (File.class.isInstance(value)) {
            return new FilePart(name, (File)value);
        }
        throw new IllegalStateException(String.format("File input parameter of %s could be %s / %s / %s or %s, but got %s.", name, Part.class.getName(), InputStream.class.getName(), Resource.class.getName(), File.class.getName(), value.getClass().getName()));
    }

    public Collection<Part> getParts() {
        Map form = (Map)this.getAttribute("servicecomb-forms");
        ArrayList<Part> partList = new ArrayList<Part>();
        this.filePartListWithForm(partList, form);
        return partList;
    }

    private void filePartListWithForm(List<Part> partList, Map<String, Object> form) {
        for (String key : this.fileKeys) {
            Object value = form.get(key);
            if (value == null) continue;
            if (Collection.class.isInstance(value)) {
                Collection collection = (Collection)value;
                for (Object part : collection) {
                    partList.add(this.getSinglePart(key, part));
                }
                continue;
            }
            if (value.getClass().isArray()) {
                Object[] params = (Object[])value;
                for (int i = 0; i < params.length; ++i) {
                    partList.add(this.getSinglePart(key, params[i]));
                }
                continue;
            }
            partList.add(this.getSinglePart(key, value));
        }
    }

    protected Object findPartInputValue(String name) {
        Map form = (Map)this.getAttribute("servicecomb-forms");
        Object value = form.get(name);
        if (value == null) {
            return null;
        }
        if (Collection.class.isInstance(value)) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return null;
            }
            value = collection.iterator().next();
        }
        return value;
    }

    @VisibleForTesting
    public List<String> getFileKeys() {
        return this.fileKeys;
    }
}

