/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.validation.ValidationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapConfiguration
extends AbstractConfiguration {
    protected ConcurrentHashMap<String, Object> map;
    private Collection<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private Collection<ConfigurationErrorListener> errorListeners = new CopyOnWriteArrayList<ConfigurationErrorListener>();
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentMapConfiguration.class);
    private static final int NUM_LOCKS = 32;
    private ReentrantLock[] locks = new ReentrantLock[32];
    public static final String DISABLE_DELIMITER_PARSING = "archaius.configuration.disableDelimiterParsing";

    public ConcurrentMapConfiguration() {
        this.map = new ConcurrentHashMap();
        for (int i = 0; i < 32; ++i) {
            this.locks[i] = new ReentrantLock();
        }
        String disableDelimiterParsing = System.getProperty(DISABLE_DELIMITER_PARSING, "false");
        super.setDelimiterParsingDisabled(Boolean.valueOf(disableDelimiterParsing).booleanValue());
    }

    public ConcurrentMapConfiguration(Map<String, Object> mapToCopy) {
        this();
        this.map = new ConcurrentHashMap<String, Object>(mapToCopy);
    }

    public ConcurrentMapConfiguration(Configuration config) {
        this();
        Iterator i = config.getKeys();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = config.getProperty(name);
            this.map.put(name, value);
        }
    }

    public Object getProperty(String key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPropertyDirect(String key, Object value) {
        ReentrantLock lock = this.locks[Math.abs(key.hashCode()) % 32];
        lock.lock();
        try {
            Object previousValue = this.map.putIfAbsent(key, value);
            if (previousValue == null) {
                return;
            }
            if (previousValue instanceof List) {
                ((List)previousValue).add(value);
            } else {
                CopyOnWriteArrayList<Object> list = new CopyOnWriteArrayList<Object>();
                list.add(previousValue);
                list.add(value);
                this.map.put(key, list);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    protected void clearPropertyDirect(String key) {
        this.map.remove(key);
    }

    public Iterator getKeys() {
        return this.map.keySet().iterator();
    }

    private void addPropertyValues(String key, Object value, char delimiter) {
        Iterator it = PropertyConverter.toIterator((Object)value, (char)delimiter);
        while (it.hasNext()) {
            this.addPropertyDirect(key, it.next());
        }
    }

    public void addProperty(String key, Object value) throws ValidationException {
        if (value == null) {
            throw new NullPointerException("Value for property " + key + " is null");
        }
        this.fireEvent(1, key, value, true);
        this.addPropertyImpl(key, value);
        this.fireEvent(1, key, value, false);
    }

    protected void addPropertyImpl(String key, Object value) {
        Object previousValue = null;
        if (this.isDelimiterParsingDisabled() || value instanceof String && ((String)value).indexOf(this.getListDelimiter()) < 0) {
            previousValue = this.map.putIfAbsent(key, value);
            if (previousValue != null) {
                this.addPropertyValues(key, value, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
            }
        } else {
            this.addPropertyValues(key, value, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
        }
    }

    public void setProperty(String key, Object value) throws ValidationException {
        if (value == null) {
            throw new NullPointerException("Value for property " + key + " is null");
        }
        this.fireEvent(3, key, value, true);
        this.setPropertyImpl(key, value);
        this.fireEvent(3, key, value, false);
    }

    protected void setPropertyImpl(String key, Object value) {
        if (this.isDelimiterParsingDisabled()) {
            this.map.put(key, value);
        } else if (value instanceof String && ((String)value).indexOf(this.getListDelimiter()) < 0) {
            this.map.put(key, value);
        } else {
            Iterator it = PropertyConverter.toIterator((Object)value, (char)this.getListDelimiter());
            CopyOnWriteArrayList list = new CopyOnWriteArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            if (list.size() == 1) {
                this.map.put(key, list.get(0));
            } else {
                this.map.put(key, list);
            }
        }
    }

    public void loadProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            this.setProperty(key, value);
        }
    }

    public void copy(Configuration c) {
        if (c != null) {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = c.getProperty(key);
                if (key == null || value == null) continue;
                this.setProperty(key, value);
            }
        }
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.map.clear();
        this.fireEvent(4, null, null, false);
    }

    public Properties getProperties() {
        Properties p = new Properties();
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = this.getString(name);
            p.put(name, value);
        }
        return p;
    }

    protected void fireEvent(int type, String propName, Object propValue, boolean beforeUpdate) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        ConfigurationEvent event = this.createEvent(type, propName, propValue, beforeUpdate);
        for (ConfigurationListener l : this.listeners) {
            try {
                l.configurationChanged(event);
            }
            catch (ValidationException e) {
                if (beforeUpdate) {
                    throw e;
                }
                logger.error("Unexpected exception", (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Error firing configuration event", e);
            }
        }
    }

    public void addConfigurationListener(ConfigurationListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void addErrorListener(ConfigurationErrorListener l) {
        if (!this.errorListeners.contains(l)) {
            this.errorListeners.add(l);
        }
    }

    public void clearConfigurationListeners() {
        this.listeners.clear();
    }

    public void clearErrorListeners() {
        this.errorListeners.clear();
    }

    public Collection<ConfigurationListener> getConfigurationListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return Collections.unmodifiableCollection(this.errorListeners);
    }

    public boolean removeConfigurationListener(ConfigurationListener l) {
        return this.listeners.remove(l);
    }

    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return this.errorListeners.remove(l);
    }

    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        if (this.errorListeners == null || this.errorListeners.size() == 0) {
            return;
        }
        ConfigurationErrorEvent event = this.createErrorEvent(type, propName, propValue, ex);
        for (ConfigurationErrorListener l : this.errorListeners) {
            try {
                l.configurationError(event);
            }
            catch (Throwable e) {
                logger.error("Error firing configuration error event", e);
            }
        }
    }
}

