/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.spectator.api.Meter;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.foundation.metrics.meter.LatencyDistributionConfig;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeConfig;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementTree;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;
import org.apache.servicecomb.metrics.core.publish.ClientEndpointsLogPublisher;
import org.apache.servicecomb.metrics.core.publish.PublishModelFactory;
import org.apache.servicecomb.metrics.core.publish.ServerEndpointsLogPublisher;
import org.apache.servicecomb.metrics.core.publish.model.DefaultPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.ThreadPoolPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogPublisher
implements MetricsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogPublisher.class);
    public static final String ENABLED = "servicecomb.metrics.publisher.defaultLog.enabled";
    public static final String ENDPOINTS_CLIENT_DETAIL_ENABLED = "servicecomb.metrics.publisher.defaultLog.endpoints.client.detail.enabled";
    private static final String FIRST_LINE_SIMPLE_FORMAT = "  %-11s %-8.1f %-18s %s%s\n";
    private static final String SIMPLE_FORMAT = "              %-8.1f %-18s %s%s\n";
    private static final String PRODUCER_DETAILS_FORMAT = "        prepare: %-18s queue       : %-18s filtersReq : %-18s handlersReq: %s\n        execute: %-18s handlersResp: %-18s filtersResp: %-18s sendResp   : %s\n";
    private static final String CONSUMER_DETAILS_FORMAT = "        prepare     : %-18s handlersReq : %-18s cFiltersReq: %-18s sendReq     : %s\n        getConnect  : %-18s writeBuf    : %-18s waitResp   : %-18s wakeConsumer: %s\n        cFiltersResp: %-18s handlersResp: %s\n";
    private static final String EDGE_DETAILS_FORMAT = "        prepare     : %-18s queue       : %-18s sFiltersReq : %-18s handlersReq : %s\n        cFiltersReq : %-18s sendReq     : %-18s getConnect  : %-18s writeBuf    : %s\n        waitResp    : %-18s wakeConsumer: %-18s cFiltersResp: %-18s handlersResp: %s\n        sFiltersResp: %-18s sendResp    : %s\n";
    private LatencyDistributionConfig latencyDistributionConfig;
    private String latencyDistributionHeader = "";
    private String latencyDistributionFormat = "";

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        if (!DynamicPropertyFactory.getInstance().getBooleanProperty(ENABLED, false).get()) {
            return;
        }
        this.initLatencyDistribution();
        eventBus.register((Object)this);
    }

    private void initLatencyDistribution() {
        int leastLatencyScopeStrLength = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.metrics.publisher.defaultLog.invocation.latencyDistribution.minScopeLength", 7).get();
        String config = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.metrics.invocation.latencyDistribution", null).get();
        this.latencyDistributionConfig = new LatencyDistributionConfig(config);
        for (LatencyScopeConfig scopeConfig : this.latencyDistributionConfig.getScopeConfigs()) {
            String header = scopeConfig.getMsMax() == Long.MAX_VALUE ? String.format("[%d,) ", scopeConfig.getMsMin()) : String.format("[%d,%d) ", scopeConfig.getMsMin(), scopeConfig.getMsMax());
            header = Strings.padEnd((String)header, (int)leastLatencyScopeStrLength, (char)' ');
            this.latencyDistributionHeader = this.latencyDistributionHeader + header;
            String format = "%-" + (header.length() - 1) + "d ";
            this.latencyDistributionFormat = this.latencyDistributionFormat + format;
        }
    }

    @Subscribe
    public void onPolledEvent(PolledEvent event) {
        try {
            this.printLog(event.getMeters());
        }
        catch (Throwable e) {
            LOGGER.error("Failed to print perf log.", e);
        }
    }

    protected void printLog(List<Meter> meters) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        PublishModelFactory factory = new PublishModelFactory(meters);
        DefaultPublishModel model = factory.createDefaultPublishModel();
        this.printOsLog(factory.getTree(), sb);
        this.printVertxMetrics(factory.getTree(), sb);
        this.printThreadPoolMetrics(model, sb);
        this.printConsumerLog(model, sb);
        this.printProducerLog(model, sb);
        this.printEdgeLog(model, sb);
        LOGGER.info(sb.toString());
    }

    protected void printOsLog(MeasurementTree tree, StringBuilder sb) {
        MeasurementNode osNode = tree.findChild("os");
        if (osNode == null || osNode.getMeasurements().isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"os:", (Object[])new Object[0]);
        this.printCpuLog(sb, osNode);
        this.printNetLog(sb, osNode);
    }

    private void printNetLog(StringBuilder sb, MeasurementNode osNode) {
        MeasurementNode netNode = osNode.findChild("net");
        if (netNode == null || netNode.getMeasurements().isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  net:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    send(Bps)    recv(Bps)    send(pps)    recv(pps)    interface", (Object[])new Object[0]);
        StringBuilder tmpSb = new StringBuilder();
        for (MeasurementNode interfaceNode : netNode.getChildren().values()) {
            double sendRate = interfaceNode.findChild(NetMeter.TAG_SEND.value()).summary();
            double sendPacketsRate = interfaceNode.findChild(NetMeter.TAG_PACKETS_SEND.value()).summary();
            double receiveRate = interfaceNode.findChild(NetMeter.TAG_RECEIVE.value()).summary();
            double receivePacketsRate = interfaceNode.findChild(NetMeter.TAG_PACKETS_RECEIVE.value()).summary();
            if (sendRate == 0.0 && receiveRate == 0.0 && receivePacketsRate == 0.0 && sendPacketsRate == 0.0) continue;
            StringBuilderUtils.appendLine((StringBuilder)tmpSb, (String)"    %-12s %-12s %-12s %-12s %s", (Object[])new Object[]{NetUtils.humanReadableBytes((long)((long)sendRate)), NetUtils.humanReadableBytes((long)((long)receiveRate)), NetUtils.humanReadableBytes((long)((long)sendPacketsRate)), NetUtils.humanReadableBytes((long)((long)receivePacketsRate)), interfaceNode.getName()});
        }
        if (tmpSb.length() != 0) {
            sb.append(tmpSb.toString());
        }
    }

    private void printCpuLog(StringBuilder sb, MeasurementNode osNode) {
        MeasurementNode cpuNode = osNode.findChild("cpu");
        MeasurementNode processNode = osNode.findChild("processCpu");
        if (cpuNode == null || cpuNode.getMeasurements().isEmpty() || processNode == null || processNode.getMeasurements().isEmpty()) {
            return;
        }
        double allRate = cpuNode.summary();
        double processRate = processNode.summary();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  cpu:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    all usage: %.2f%%    all idle: %.2f%%    process: %.2f%%", (Object[])new Object[]{allRate * 100.0, (1.0 - allRate) * 100.0, processRate * 100.0});
    }

    protected void printThreadPoolMetrics(DefaultPublishModel model, StringBuilder sb) {
        if (model.getThreadPools().isEmpty()) {
            return;
        }
        sb.append("threadPool:\n");
        sb.append("  coreSize maxThreads poolSize currentBusy rejected queueSize taskCount taskFinished name\n");
        for (Map.Entry<String, ThreadPoolPublishModel> entry : model.getThreadPools().entrySet()) {
            ThreadPoolPublishModel threadPoolPublishModel = entry.getValue();
            sb.append(String.format("  %-8d %-10d %-8d %-11d %-8.0f %-9d %-9.1f %-12.1f %s\n", threadPoolPublishModel.getCorePoolSize(), threadPoolPublishModel.getMaxThreads(), threadPoolPublishModel.getPoolSize(), threadPoolPublishModel.getCurrentThreadsBusy(), threadPoolPublishModel.getRejected(), threadPoolPublishModel.getQueueSize(), threadPoolPublishModel.getAvgTaskCount(), threadPoolPublishModel.getAvgCompletedTaskCount(), entry.getKey()));
        }
    }

    protected void printEdgeLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups edgePerf = model.getEdge().getOperationPerfGroups();
        if (edgePerf == null) {
            return;
        }
        sb.append("edge:\n simple:\n  status      tps      latency            ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : edgePerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printEdgeDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    protected void printConsumerLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups consumerPerf = model.getConsumer().getOperationPerfGroups();
        if (consumerPerf == null) {
            return;
        }
        sb.append("consumer:\n simple:\n  status      tps      latency            ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : consumerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printConsumerDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    protected void printProducerLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups producerPerf = model.getProducer().getOperationPerfGroups();
        if (producerPerf == null) {
            return;
        }
        sb.append("producer:\n simple:\n  status      tps      latency            ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : producerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printProducerDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    private StringBuilder printSamplePerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
            OperationPerf operationPerf = perfGroup.getOperationPerfs().get(i);
            PerfInfo stageTotal = operationPerf.findStage("total");
            if (i == 0) {
                String status = perfGroup.getTransport() + "." + perfGroup.getStatus();
                sb.append(String.format(FIRST_LINE_SIMPLE_FORMAT, status, stageTotal.getTps(), DefaultLogPublisher.getDetailsFromPerf(stageTotal), this.formatLatencyDistribution(operationPerf), operationPerf.getOperation()));
                continue;
            }
            sb.append(String.format(SIMPLE_FORMAT, stageTotal.getTps(), DefaultLogPublisher.getDetailsFromPerf(stageTotal), this.formatLatencyDistribution(operationPerf), operationPerf.getOperation()));
        }
        OperationPerf summaryOperation = perfGroup.getSummary();
        PerfInfo stageSummaryTotal = summaryOperation.findStage("total");
        sb.append(String.format(SIMPLE_FORMAT, stageSummaryTotal.getTps(), DefaultLogPublisher.getDetailsFromPerf(stageSummaryTotal), this.formatLatencyDistribution(summaryOperation), "(summary)"));
        return sb;
    }

    private String formatLatencyDistribution(OperationPerf operationPerf) {
        return String.format(this.latencyDistributionFormat, operationPerf.getLatencyDistribution());
    }

    private StringBuilder printProducerDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo queue = operationPerf.findStage("queue");
            PerfInfo filtersReq = operationPerf.findStage("server_filters_request");
            PerfInfo handlersReq = operationPerf.findStage("handlers_request");
            PerfInfo execute = operationPerf.findStage("execution");
            PerfInfo handlersResp = operationPerf.findStage("handlers_response");
            PerfInfo filtersResp = operationPerf.findStage("server_filters_response");
            PerfInfo sendResp = operationPerf.findStage("producer_send_response");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(PRODUCER_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(queue), DefaultLogPublisher.getDetailsFromPerf(filtersReq), DefaultLogPublisher.getDetailsFromPerf(handlersReq), DefaultLogPublisher.getDetailsFromPerf(execute), DefaultLogPublisher.getDetailsFromPerf(handlersResp), DefaultLogPublisher.getDetailsFromPerf(filtersResp), DefaultLogPublisher.getDetailsFromPerf(sendResp)));
        }
        return sb;
    }

    private StringBuilder printConsumerDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo handlersReq = operationPerf.findStage("handlers_request");
            PerfInfo clientFiltersReq = operationPerf.findStage("client_filters_request");
            PerfInfo sendReq = operationPerf.findStage("consumer_send_request");
            PerfInfo getConnect = operationPerf.findStage("consumer_get_connection");
            PerfInfo writeBuf = operationPerf.findStage("consumer_write_to_buf");
            PerfInfo waitResp = operationPerf.findStage("consumer_wait_response");
            PerfInfo wakeConsumer = operationPerf.findStage("consumer_wake_consumer");
            PerfInfo clientFiltersResp = operationPerf.findStage("client_filters_response");
            PerfInfo handlersResp = operationPerf.findStage("handlers_response");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(CONSUMER_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(handlersReq), DefaultLogPublisher.getDetailsFromPerf(clientFiltersReq), DefaultLogPublisher.getDetailsFromPerf(sendReq), DefaultLogPublisher.getDetailsFromPerf(getConnect), DefaultLogPublisher.getDetailsFromPerf(writeBuf), DefaultLogPublisher.getDetailsFromPerf(waitResp), DefaultLogPublisher.getDetailsFromPerf(wakeConsumer), DefaultLogPublisher.getDetailsFromPerf(clientFiltersResp), DefaultLogPublisher.getDetailsFromPerf(handlersResp)));
        }
        return sb;
    }

    private StringBuilder printEdgeDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo queue = operationPerf.findStage("queue");
            PerfInfo serverFiltersReq = operationPerf.findStage("server_filters_request");
            PerfInfo handlersReq = operationPerf.findStage("handlers_request");
            PerfInfo clientFiltersReq = operationPerf.findStage("client_filters_request");
            PerfInfo sendReq = operationPerf.findStage("consumer_send_request");
            PerfInfo getConnect = operationPerf.findStage("consumer_get_connection");
            PerfInfo writeBuf = operationPerf.findStage("consumer_write_to_buf");
            PerfInfo waitResp = operationPerf.findStage("consumer_wait_response");
            PerfInfo wakeConsumer = operationPerf.findStage("consumer_wake_consumer");
            PerfInfo clientFiltersResp = operationPerf.findStage("client_filters_response");
            PerfInfo handlersResp = operationPerf.findStage("handlers_response");
            PerfInfo serverFiltersResp = operationPerf.findStage("server_filters_response");
            PerfInfo sendResp = operationPerf.findStage("producer_send_response");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(EDGE_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(queue), DefaultLogPublisher.getDetailsFromPerf(serverFiltersReq), DefaultLogPublisher.getDetailsFromPerf(handlersReq), DefaultLogPublisher.getDetailsFromPerf(clientFiltersReq), DefaultLogPublisher.getDetailsFromPerf(sendReq), DefaultLogPublisher.getDetailsFromPerf(getConnect), DefaultLogPublisher.getDetailsFromPerf(writeBuf), DefaultLogPublisher.getDetailsFromPerf(waitResp), DefaultLogPublisher.getDetailsFromPerf(wakeConsumer), DefaultLogPublisher.getDetailsFromPerf(clientFiltersResp), DefaultLogPublisher.getDetailsFromPerf(handlersResp), DefaultLogPublisher.getDetailsFromPerf(serverFiltersResp), DefaultLogPublisher.getDetailsFromPerf(sendResp)));
        }
        return sb;
    }

    protected void printVertxMetrics(MeasurementTree tree, StringBuilder sb) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"vertx:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  instances:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    name       eventLoopContext-created", (Object[])new Object[0]);
        for (Map.Entry entry : VertxUtils.getVertxMap().entrySet()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    %-10s %d", (Object[])new Object[]{entry.getKey(), 0});
        }
        ClientEndpointsLogPublisher client = new ClientEndpointsLogPublisher(tree, sb, "client");
        ServerEndpointsLogPublisher server = new ServerEndpointsLogPublisher(tree, sb, "server");
        if (client.isExists() || server.isExists()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  transport:", (Object[])new Object[0]);
            if (client.isExists()) {
                client.print(DynamicPropertyFactory.getInstance().getBooleanProperty(ENDPOINTS_CLIENT_DETAIL_ENABLED, false).get());
            }
            if (server.isExists()) {
                server.print(true);
            }
        }
    }

    private static String getDetailsFromPerf(PerfInfo perfInfo) {
        String result = "";
        if (perfInfo != null) {
            result = String.format("%.3f/%.3f", perfInfo.calcMsLatency(), perfInfo.getMsMaxLatency());
        }
        return result;
    }
}

