/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CookieHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.EdgeInvocation;
import org.apache.servicecomb.edge.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMappedEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(URLMappedEdgeDispatcher.class);
    private static final String PATTERN_ANY = "/(.*)";
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.url.enabled";
    private static final String KEY_MAPPING_PREIX = "servicecomb.http.dispatcher.edge.url.mappings";
    private static final String KEY_MAPPING_PATH = ".path";
    private static final String KEY_MAPPING_SERVICE_NAME = "servicecomb.http.dispatcher.edge.url.mappings.%s.microserviceName";
    private static final String KEY_MAPPING_VERSION_RULE = "servicecomb.http.dispatcher.edge.url.mappings.%s.versionRule";
    private static final String KEY_MAPPING_PREFIX_SEGMENT_COUNT = "servicecomb.http.dispatcher.edge.url.mappings.%s.prefixSegmentCount";
    private Map<String, ConfigurationItem> configurations = new HashMap<String, ConfigurationItem>();

    public URLMappedEdgeDispatcher() {
        if (this.enabled()) {
            this.loadConfigurations();
        }
    }

    public int getOrder() {
        return 30000;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
    }

    public void init(Router router) {
        router.routeWithRegex(PATTERN_ANY).handler((Handler)CookieHandler.create());
        router.routeWithRegex(PATTERN_ANY).handler((Handler)this.createBodyHandler());
        router.routeWithRegex(PATTERN_ANY).failureHandler(this::onFailure).handler(this::onRequest);
    }

    private void loadConfigurations() {
        ConcurrentCompositeConfiguration config = (ConcurrentCompositeConfiguration)DynamicPropertyFactory.getBackingConfigurationSource();
        this.loadConfigurations(config);
        config.addConfigurationListener(event -> {
            if (event.getPropertyName().startsWith(KEY_MAPPING_PREIX)) {
                LOG.info("Map rule have been changed. Reload configurations. Event=" + event.getType());
                this.loadConfigurations(config);
            }
        });
    }

    private void loadConfigurations(ConcurrentCompositeConfiguration config) {
        HashMap<String, ConfigurationItem> configurations = new HashMap<String, ConfigurationItem>();
        Iterator configsItems = config.getKeys(KEY_MAPPING_PREIX);
        while (configsItems.hasNext()) {
            String pathKey = (String)configsItems.next();
            if (!pathKey.endsWith(KEY_MAPPING_PATH)) continue;
            ConfigurationItem configurationItem = new ConfigurationItem();
            String pattern = DynamicPropertyFactory.getInstance().getStringProperty(pathKey, null).get();
            if (StringUtils.isEmpty((CharSequence)pattern)) continue;
            configurationItem.pattern = Pattern.compile(pattern);
            configurationItem.stringPattern = pattern;
            String pathKeyItem = pathKey.substring(KEY_MAPPING_PREIX.length() + 1, pathKey.length() - KEY_MAPPING_PATH.length());
            configurationItem.microserviceName = DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_MAPPING_SERVICE_NAME, pathKeyItem), null).get();
            if (StringUtils.isEmpty((CharSequence)configurationItem.microserviceName)) continue;
            configurationItem.prefixSegmentCount = DynamicPropertyFactory.getInstance().getIntProperty(String.format(KEY_MAPPING_PREFIX_SEGMENT_COUNT, pathKeyItem), 0).get();
            configurationItem.versionRule = DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_MAPPING_VERSION_RULE, pathKeyItem), "0.0.0+").get();
            configurations.put(pathKeyItem, configurationItem);
        }
        this.configurations = configurations;
        this.logConfigurations();
    }

    private void logConfigurations() {
        for (String key : this.configurations.keySet()) {
            ConfigurationItem item = this.configurations.get(key);
            LOG.info("config item: key=" + key + ";pattern=" + item.stringPattern + ";service=" + item.microserviceName + ";versionRule=" + item.versionRule);
        }
    }

    protected void onRequest(RoutingContext context) {
        ConfigurationItem configurationItem = this.findConfigurationItem(context.request().path());
        if (configurationItem == null) {
            context.next();
            return;
        }
        String path = Utils.findActualPath(context.request().path(), configurationItem.prefixSegmentCount);
        EdgeInvocation edgeInvocation = new EdgeInvocation();
        if (configurationItem.versionRule != null) {
            edgeInvocation.setVersionRule(configurationItem.versionRule);
        }
        edgeInvocation.init(configurationItem.microserviceName, context, path, this.httpServerFilters);
        edgeInvocation.edgeInvoke();
    }

    private ConfigurationItem findConfigurationItem(String path) {
        for (ConfigurationItem item : this.configurations.values()) {
            if (!item.pattern.matcher(path).matches()) continue;
            return item;
        }
        return null;
    }

    class ConfigurationItem {
        String microserviceName;
        String versionRule;
        int prefixSegmentCount;
        Pattern pattern;
        String stringPattern;

        ConfigurationItem() {
        }
    }
}

