/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CookieHandler;
import java.util.Map;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.CompatiblePathVersionMapper;
import org.apache.servicecomb.edge.core.EdgeInvocation;
import org.apache.servicecomb.edge.core.Utils;

public class DefaultEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.default.enabled";
    private static final String KEY_PREFIX = "servicecomb.http.dispatcher.edge.default.prefix";
    private static final String KEY_WITH_VERSION = "servicecomb.http.dispatcher.edge.default.withVersion";
    private static final String KEY_PREFIX_SEGMENT_COUNT = "servicecomb.http.dispatcher.edge.default.prefixSegmentCount";
    private CompatiblePathVersionMapper versionMapper = new CompatiblePathVersionMapper();
    private String prefix;
    private boolean withVersion;
    private int prefixSegmentCount;

    public int getOrder() {
        return 20000;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
    }

    public void init(Router router) {
        this.prefix = DynamicPropertyFactory.getInstance().getStringProperty(KEY_PREFIX, "api").get();
        this.withVersion = DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_WITH_VERSION, true).get();
        this.prefixSegmentCount = DynamicPropertyFactory.getInstance().getIntProperty(KEY_PREFIX_SEGMENT_COUNT, 1).get();
        String regex = this.withVersion ? "/" + this.prefix + "/([^\\\\/]+)/([^\\\\/]+)/(.*)" : "/" + this.prefix + "/([^\\\\/]+)/(.*)";
        router.routeWithRegex(regex).handler((Handler)CookieHandler.create());
        router.routeWithRegex(regex).handler((Handler)this.createBodyHandler());
        router.routeWithRegex(regex).failureHandler(this::onFailure).handler(this::onRequest);
    }

    protected void onRequest(RoutingContext context) {
        Map pathParams = context.pathParams();
        String microserviceName = (String)pathParams.get("param0");
        String path = Utils.findActualPath(context.request().path(), this.prefixSegmentCount);
        EdgeInvocation edgeInvocation = new EdgeInvocation();
        if (this.withVersion) {
            String pathVersion = (String)pathParams.get("param1");
            edgeInvocation.setVersionRule(this.versionMapper.getOrCreate(pathVersion).getVersionRule());
        }
        edgeInvocation.init(microserviceName, context, path, this.httpServerFilters);
        edgeInvocation.edgeInvoke();
    }
}

