/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.List;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.actuate.endpoint.mvc.NamedMvcEndpoint;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

class LinksEnhancer {
    private final String rootPath;
    private final MvcEndpoints endpoints;

    LinksEnhancer(String rootPath, MvcEndpoints endpoints) {
        this.rootPath = rootPath;
        this.endpoints = endpoints;
    }

    public void addEndpointLinks(ResourceSupport resource, String self) {
        if (!resource.hasLink("self")) {
            resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(LinksEnhancer.class).slash((Object)(this.rootPath + self))).withSelfRel());
        }
        LinkedMultiValueMap added = new LinkedMultiValueMap();
        for (MvcEndpoint endpoint : this.endpoints.getEndpoints()) {
            String rel;
            List paths;
            if (endpoint.getPath().equals(self) || (paths = (List)added.get((Object)(rel = this.getRel(endpoint)))) != null && paths.contains(endpoint.getPath())) continue;
            this.addEndpointLink(resource, endpoint, rel);
            added.add((Object)rel, (Object)endpoint.getPath());
        }
    }

    private String getRel(MvcEndpoint endpoint) {
        if (endpoint instanceof NamedMvcEndpoint) {
            return ((NamedMvcEndpoint)endpoint).getName();
        }
        String path = endpoint.getPath();
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private void addEndpointLink(ResourceSupport resource, MvcEndpoint endpoint, String rel) {
        Class type = endpoint.getEndpointType();
        Class clazz = type = type == null ? Object.class : type;
        if (StringUtils.hasText((String)rel)) {
            String href = this.rootPath + endpoint.getPath();
            resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(type).slash((Object)href)).withRel(rel));
        }
    }
}

