/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.foundation.common.io.AsyncCloseable;
import org.apache.servicecomb.foundation.vertx.stream.InputStreamToReadStream;

public class PumpCommon {
    public CompletableFuture<Void> pump(Context context, ReadStream<Buffer> readStream, WriteStream<Buffer> writeStream) {
        CompletableFuture<Void> readFuture = new CompletableFuture<Void>();
        writeStream.exceptionHandler(e -> {
            if (readStream instanceof InputStreamToReadStream) {
                ((InputStreamToReadStream)readStream).handleException((Throwable)e);
            } else if (readStream instanceof HttpClientResponse) {
                ((HttpClientResponse)readStream).request().connection().close();
            }
            readFuture.completeExceptionally((Throwable)e);
        });
        readStream.exceptionHandler(readFuture::completeExceptionally);
        readStream.endHandler(readFuture::complete);
        Pump.pump(readStream, writeStream).start();
        try {
            context.runOnContext(v -> readStream.resume());
        }
        catch (Throwable e2) {
            readFuture.completeExceptionally(e2);
        }
        if (!AsyncCloseable.class.isInstance(writeStream)) {
            return readFuture;
        }
        return this.closeWriteStream((AsyncCloseable<Void>)((AsyncCloseable)writeStream), readFuture);
    }

    protected CompletableFuture<Void> closeWriteStream(AsyncCloseable<Void> writeStream, CompletableFuture<Void> readFuture) {
        CompletableFuture writeFuture = new CompletableFuture();
        readFuture.whenComplete((v, e) -> writeStream.close().whenComplete((wv, we) -> {
            if (we != null) {
                writeFuture.completeExceptionally((Throwable)we);
                return;
            }
            writeFuture.complete(null);
        }));
        return CompletableFuture.allOf(readFuture, writeFuture);
    }
}

