/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageInfoFactory;

class GeneratedMessageInfoFactory
implements MessageInfoFactory {
    private static final GeneratedMessageInfoFactory instance = new GeneratedMessageInfoFactory();

    private GeneratedMessageInfoFactory() {
    }

    public static GeneratedMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> messageType) {
        return GeneratedMessageLite.class.isAssignableFrom(messageType);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> messageType) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            String string = String.valueOf(messageType.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unsupported message type: ".concat(string) : new String("Unsupported message type: "));
        }
        try {
            return (MessageInfo)GeneratedMessageLite.getDefaultInstance(messageType.asSubclass(GeneratedMessageLite.class)).buildMessageInfo();
        }
        catch (Exception e) {
            String string = String.valueOf(messageType.getName());
            throw new RuntimeException(string.length() != 0 ? "Unable to get message info for ".concat(string) : new String("Unable to get message info for "), e);
        }
    }
}

