/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.NonNull;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.core.starter.command.AbstractCommandArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static Path getConfigPath(@NonNull AbstractCommandArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        switch (args.getDeployMode()) {
            case RUN: 
            case CLIENT: {
                return Paths.get(args.getConfigFile(), new String[0]);
            }
            case RUN_APPLICATION: 
            case CLUSTER: {
                return Paths.get(FileUtils.getFileName(args.getConfigFile()), new String[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported deploy mode: " + args.getDeployMode());
    }

    public static void checkConfigExist(Path configFile) {
        if (!configFile.toFile().exists()) {
            throw CommonError.fileNotExistFailed((String)"SeaTunnel", (String)"read", (String)configFile.toString());
        }
    }

    private static String getFileName(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
    }

    public static String getFileExtension(@NonNull String fullName) {
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }
}

