/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Graph } from '@antv/x6'
import { DagEdgeName } from './dag-setting'

export function useDagGraph(
  graph: any,
  dagContainer: HTMLElement,
  minimapContainer: HTMLElement
) {
  return new Graph({
    container: dagContainer,
    scroller: true,
    grid: {
      size: 10,
      visible: true
    },
    connecting: {
      // router: 'orth',
      allowBlank: false,
      allowLoop: false,
      createEdge() {
        return graph.value?.createEdge({ shape: DagEdgeName })
      }
    },
    minimap: {
      enabled: true,
      width: 200,
      height: 120,
      container: minimapContainer
    }
  })
}
