/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.utils;

import io.jsonwebtoken.ExpiredJwtException;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={SeatunnelException.class})
    private Result<String> portalExceptionHandler(SeatunnelException e) {
        this.logError(e);
        String message = e.getMessage();
        SeatunnelErrorEnum errorEnum = e.getErrorEnum();
        return Result.failure(errorEnum, message);
    }

    @ExceptionHandler(value={DataSourcePluginException.class})
    private Result<String> dsHandler(DataSourcePluginException e) {
        this.logError((Throwable)e);
        String message = e.getMessage();
        return Result.failure(SeatunnelErrorEnum.INVALID_DATASOURCE, e.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    private Result<String> missParam(MissingServletRequestParameterException e) {
        this.logError((Throwable)e);
        return Result.failure(SeatunnelErrorEnum.MISSING_PARAM, e.getParameterName());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    private Result<String> illegalStateExceptionHandler(IllegalStateException e) {
        this.logError(e);
        return Result.failure(SeatunnelErrorEnum.ILLEGAL_STATE, e.getMessage());
    }

    @ExceptionHandler(value={ExpiredJwtException.class})
    private Result<String> expiredJwtException(ExpiredJwtException e) {
        this.logError((Throwable)e);
        return Result.failure(SeatunnelErrorEnum.TOKEN_ILLEGAL, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    private Result<String> exceptionHandler(Exception e) {
        this.logError(e);
        return Result.failure(SeatunnelErrorEnum.UNKNOWN, e.getMessage());
    }

    private void logError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
    }
}

