/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.execution;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionEdge;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionVertex;

public class Pipeline {
    private final Integer id;
    private final List<ExecutionEdge> edges;
    private final Map<Long, ExecutionVertex> vertexes;

    Pipeline(Integer id, List<ExecutionEdge> edges, Map<Long, ExecutionVertex> vertexes) {
        this.id = id;
        this.edges = edges;
        this.vertexes = vertexes;
    }

    public Integer getId() {
        return this.id;
    }

    public List<ExecutionEdge> getEdges() {
        return this.edges;
    }

    public Map<Long, ExecutionVertex> getVertexes() {
        return this.vertexes;
    }

    public Map<ActionStateKey, Integer> getActions() {
        return this.vertexes.values().stream().map(ExecutionVertex::getAction).collect(Collectors.toMap(action -> ActionStateKey.of(action), Action::getParallelism));
    }
}

