/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.FieldDescriptorCodec;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import java.util.List;

public final class SchemaCodec {
    private SchemaCodec() {
    }

    public static void encode(ClientMessage clientMessage, Schema schema) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        StringCodec.encode(clientMessage, schema.getTypeName());
        ListMultiFrameCodec.encode(clientMessage, schema.getFields(), FieldDescriptorCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static Schema decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        String typeName = StringCodec.decode(iterator);
        List<FieldDescriptor> fields = ListMultiFrameCodec.decode(iterator, FieldDescriptorCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createSchema(typeName, fields);
    }
}

