/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.converter;

import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public interface DataConverter<T>
extends Serializable {
    public String identifier();

    public Object convert(SeaTunnelDataType var1, Object var2);

    default public Object convert(Column columnDefine, Object value) {
        return this.convert(columnDefine.getDataType(), value);
    }

    default public Object convert(T typeDefine, Column columnDefine, Object value) {
        return this.convert(columnDefine, value);
    }

    default public Object[] convert(T[] typeDefine, Column[] columnDefine, Object[] value) {
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.convert(typeDefine != null ? (T)typeDefine[i] : null, columnDefine[i], value[i]);
        }
        return value;
    }

    default public Object[] convert(Column[] columnDefine, Function<Column[], Object[]> valueApply) {
        Object[] fields = valueApply.apply(columnDefine);
        if (fields.length != columnDefine.length) {
            throw new IllegalStateException("columnDefine size not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.convert(columnDefine[i], fields[i]);
        }
        return fields;
    }

    default public Object[] convert(T[] typeDefine, Column[] columnDefine, BiFunction<T[], Column[], Object[]> valueApply) {
        boolean hasTypeDefine;
        boolean bl = hasTypeDefine = typeDefine != null;
        if (hasTypeDefine && typeDefine.length != columnDefine.length) {
            throw new IllegalStateException("typeDefine size not match");
        }
        Object[] fields = valueApply.apply(typeDefine, columnDefine);
        if (fields.length != columnDefine.length) {
            throw new IllegalStateException("columnDefine size not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.convert(hasTypeDefine ? (T)typeDefine[i] : null, columnDefine[i], fields[i]);
        }
        return fields;
    }

    default public Object reconvert(T typeDefine, Column columnDefine, Object value) {
        return this.reconvert(typeDefine, value);
    }

    default public Object reconvert(T typeDefine, Object value) {
        throw new UnsupportedOperationException("reconvert not support");
    }

    default public Object reconvert(Column columnDefine, Object value) {
        return this.reconvert(columnDefine.getDataType(), value);
    }

    default public Object reconvert(SeaTunnelDataType typeDefine, Object value) {
        throw new UnsupportedOperationException("reconvert not support");
    }
}

