/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSeaTunnelTask;

public class AssignSplitOperation<SplitT extends SourceSplit>
extends Operation
implements IdentifiedDataSerializable {
    private List<byte[]> splits;
    private TaskLocation taskID;

    public AssignSplitOperation() {
    }

    public AssignSplitOperation(TaskLocation taskID, List<byte[]> splits) {
        this.taskID = taskID;
        this.splits = splits;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            SourceSeaTunnelTask task = (SourceSeaTunnelTask)server.getTaskExecutionService().getTask(this.taskID);
            ClassLoader taskClassLoader = server.getTaskExecutionService().getExecutionContext(this.taskID.getTaskGroupLocation()).getClassLoader();
            ClassLoader mainClassLoader = Thread.currentThread().getContextClassLoader();
            ArrayList deserializeSplits = new ArrayList();
            try {
                Thread.currentThread().setContextClassLoader(taskClassLoader);
                for (byte[] split : this.splits) {
                    deserializeSplits.add(task.getSplitSerializer().deserialize(split));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(mainClassLoader);
            }
            task.receivedSourceSplit(deserializeSplits);
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.splits.size());
        for (byte[] split : this.splits) {
            out.writeByteArray(split);
        }
        out.writeObject(this.taskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int splitCount = in.readInt();
        this.splits = new ArrayList<byte[]>(splitCount);
        for (int i = 0; i < splitCount; ++i) {
            this.splits.add(in.readByteArray());
        }
        this.taskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

