/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCShutdownClusterCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import java.security.Permission;
import java.util.concurrent.Future;

public class ShutdownClusterMessageTask
extends AbstractCallableMessageTask<Void> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("cluster.shutdown");

    public ShutdownClusterMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        Future<Void> future = executionService.submit("hz:async", () -> {
            this.nodeEngine.getClusterService().shutdown();
            return null;
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (empty, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : null)), ConcurrencyUtil.CALLER_RUNS);
        return null;
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCShutdownClusterCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "shutdownCluster";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

