/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.server.dag.physical.config.SourceConfig;
import org.apache.seatunnel.engine.server.dag.physical.flow.Flow;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelSourceCollector;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.TaskRuntimeException;
import org.apache.seatunnel.engine.server.task.flow.SourceFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class SourceSeaTunnelTask<T, SplitT extends SourceSplit>
extends SeaTunnelTask {
    private static final ILogger LOGGER = Logger.getLogger(SourceSeaTunnelTask.class);
    private transient SeaTunnelSourceCollector<T> collector;
    private transient Object checkpointLock;

    public SourceSeaTunnelTask(long jobID, TaskLocation taskID, int indexID, Flow executionFlow) {
        super(jobID, taskID, indexID, executionFlow);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.checkpointLock = new Object();
        LOGGER.info("starting seatunnel source task, index " + this.indexID);
        if (!(this.startFlowLifeCycle instanceof SourceFlowLifeCycle)) {
            throw new TaskRuntimeException("SourceSeaTunnelTask only support SourceFlowLifeCycle, but get " + this.startFlowLifeCycle.getClass().getName());
        }
        this.collector = new SeaTunnelSourceCollector(this.checkpointLock, this.outputs, this.getMetricsContext());
        ((SourceFlowLifeCycle)this.startFlowLifeCycle).setCollector(this.collector);
    }

    @Override
    protected SourceFlowLifeCycle<?, ?> createSourceFlowLifeCycle(SourceAction<?, ?, ?> sourceAction, SourceConfig config, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        return new SourceFlowLifeCycle(sourceAction, this.indexID, config.getEnumeratorTask(), this, this.taskLocation, completableFuture, metricsContext);
    }

    @Override
    protected void collect() throws Exception {
        ((SourceFlowLifeCycle)this.startFlowLifeCycle).collect();
    }

    @Override
    @NonNull
    public ProgressState call() throws Exception {
        this.stateProcess();
        return this.progress.toState();
    }

    public void receivedSourceSplit(List<SplitT> splits) {
        ((SourceFlowLifeCycle)this.startFlowLifeCycle).receivedSplits(splits);
    }

    @Override
    public void triggerBarrier(Barrier barrier) throws Exception {
        SourceFlowLifeCycle sourceFlow = (SourceFlowLifeCycle)this.startFlowLifeCycle;
        sourceFlow.triggerBarrier(barrier);
    }
}

