/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.serializable;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;

public class RecordSerializer
implements StreamSerializer<Record> {
    @Override
    public void write(ObjectDataOutput out, Record record) throws IOException {
        Object data = record.getData();
        if (data instanceof CheckpointBarrier) {
            CheckpointBarrier checkpointBarrier = (CheckpointBarrier)data;
            out.writeByte(RecordDataType.CHECKPOINT_BARRIER.ordinal());
            out.writeLong(checkpointBarrier.getId());
            out.writeLong(checkpointBarrier.getTimestamp());
            out.writeString(checkpointBarrier.getCheckpointType().getName());
        } else if (data instanceof SeaTunnelRow) {
            SeaTunnelRow row = (SeaTunnelRow)data;
            out.writeByte(RecordDataType.SEATUNNEL_ROW.ordinal());
            out.writeString(row.getTableId());
            out.writeByte(row.getRowKind().toByteValue());
            out.writeByte(row.getArity());
            for (Object field2 : row.getFields()) {
                out.writeObject(field2);
            }
        } else {
            throw new UnsupportedEncodingException("Unsupported serialize class: " + data.getClass());
        }
    }

    @Override
    public Record read(ObjectDataInput in) throws IOException {
        Serializable data;
        byte dataType = in.readByte();
        if (dataType == RecordDataType.CHECKPOINT_BARRIER.ordinal()) {
            data = new CheckpointBarrier(in.readLong(), in.readLong(), CheckpointType.valueOf(in.readString()));
        } else if (dataType == RecordDataType.SEATUNNEL_ROW.ordinal()) {
            String tableId = in.readString();
            byte rowKind = in.readByte();
            int arity = in.readByte();
            SeaTunnelRow row = new SeaTunnelRow(arity);
            row.setTableId(tableId);
            row.setRowKind(RowKind.fromByteValue(rowKind));
            for (int i = 0; i < arity; ++i) {
                row.setField(i, in.readObject());
            }
            data = row;
        } else {
            throw new UnsupportedEncodingException("Unsupported deserialize data type: " + dataType);
        }
        return new Record<CheckpointBarrier>((CheckpointBarrier)data);
    }

    @Override
    public int getTypeId() {
        return 1;
    }

    static enum RecordDataType {
        CHECKPOINT_BARRIER,
        SEATUNNEL_ROW;

    }
}

