/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskGroupContext;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTaskRestoreOperation
extends TaskOperation {
    private static final Logger log = LoggerFactory.getLogger(NotifyTaskRestoreOperation.class);
    private List<ActionSubtaskState> restoredState;

    public NotifyTaskRestoreOperation(TaskLocation taskLocation, List<ActionSubtaskState> restoredState) {
        super(taskLocation);
        this.restoredState = restoredState;
    }

    @Override
    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.restoredState.size());
        for (ActionSubtaskState state : this.restoredState) {
            out.writeObject(state);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size2 = in.readInt();
        this.restoredState = new ArrayList<ActionSubtaskState>(size2);
        for (int i = 0; i < size2; ++i) {
            this.restoredState.add((ActionSubtaskState)in.readObject());
        }
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            log.debug("NotifyTaskRestoreOperation " + this.taskLocation);
            TaskGroupContext groupContext = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation());
            Object task = groupContext.getTaskGroup().getTask(this.taskLocation.getTaskID());
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(groupContext.getClassLoader());
                log.debug("NotifyTaskRestoreOperation.restoreState " + this.restoredState);
                task.restoreState(this.restoredState);
                log.debug("NotifyTaskRestoreOperation.finished " + this.restoredState);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Exception e) {
                throw new SeaTunnelException(e);
            }
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public NotifyTaskRestoreOperation() {
    }
}

