/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration;

import java.util.Objects;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;

public class Option<T> {
    private final String key;
    private final TypeReference<T> typeReference;
    private final T defaultValue;
    String description = "";

    public Option(String key, TypeReference<T> typeReference, T defaultValue) {
        this.key = key;
        this.typeReference = typeReference;
        this.defaultValue = defaultValue;
    }

    public String key() {
        return this.key;
    }

    public TypeReference<T> typeReference() {
        return this.typeReference;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public Option<T> withDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option that = (Option)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.defaultValue);
    }

    public String toString() {
        return String.format("Key: '%s', default: %s", this.key, this.defaultValue);
    }
}

