/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.AbstractPredicate;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BinaryInterface
public class LikePredicate
extends AbstractPredicate
implements IndexAwarePredicate {
    private static final long serialVersionUID = 1L;
    protected String expression;
    private volatile transient Pattern pattern;

    public LikePredicate() {
    }

    public LikePredicate(String attributeName, String expression) {
        super(attributeName);
        this.expression = expression;
    }

    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Index index = queryContext.matchIndex(this.attributeName, QueryContext.IndexMatchHint.PREFER_ORDERED);
        String indexPrefix = this.expression.substring(0, this.expression.length() - 1);
        return index.getRecords((Comparable)((Object)indexPrefix), true, (Comparable)((Object)(indexPrefix + "\uffff")), false);
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        Index index = queryContext.matchIndex(this.attributeName, QueryContext.IndexMatchHint.PREFER_ORDERED);
        return index != null && index.isOrdered() && this.expressionCanBeUsedAsIndexPrefix();
    }

    private boolean expressionCanBeUsedAsIndexPrefix() {
        boolean escape = false;
        for (int i = 0; i < this.expression.length(); ++i) {
            char c = this.expression.charAt(i);
            if (c == '\\') {
                escape = !escape;
                continue;
            }
            if (c == '%' && !escape) {
                return i == this.expression.length() - 1;
            }
            if (c == '_' && !escape) {
                return false;
            }
            escape = false;
        }
        return false;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Comparable attributeValue) {
        String attributeValueString = (String)((Object)attributeValue);
        if (attributeValueString == null) {
            return this.expression == null;
        }
        if (this.expression == null) {
            return false;
        }
        this.pattern = this.pattern != null ? this.pattern : this.createPattern(this.expression);
        Matcher m3 = this.pattern.matcher(attributeValueString);
        return m3.matches();
    }

    private Pattern createPattern(String expression) {
        String quotedExpression = Pattern.quote(expression);
        String regex = quotedExpression.replaceAll("(?<!\\\\)[%]", "\\\\E.*\\\\Q").replaceAll("(?<!\\\\)[_]", "\\\\E.\\\\Q").replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
        int flags = this.getFlags();
        return Pattern.compile(regex, flags);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.expression);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.expression = in.readString();
    }

    protected int getFlags() {
        return 32;
    }

    public String toString() {
        return this.attributeName + " LIKE '" + this.expression + "'";
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LikePredicate)) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof LikePredicate;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.expression != null ? this.expression.hashCode() : 0);
        return result2;
    }
}

