/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomicref.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRef;
import com.hazelcast.cp.internal.datastructures.atomicref.operation.AbstractAtomicRefOp;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class CompareAndSetOp
extends AbstractAtomicRefOp
implements IdentifiedDataSerializable {
    private Data expectedValue;
    private Data newValue;

    public CompareAndSetOp() {
    }

    public CompareAndSetOp(String name, Data expectedValue, Data newValue) {
        super(name);
        this.expectedValue = expectedValue;
        this.newValue = newValue;
    }

    @Override
    public Object run(CPGroupId groupId, long commitIndex) {
        AtomicRef ref = this.getAtomicRef(groupId);
        boolean contains2 = ref.contains(this.expectedValue);
        if (contains2) {
            ref.set(this.newValue);
        }
        return contains2;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        IOUtil.writeData(out, this.expectedValue);
        IOUtil.writeData(out, this.newValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.expectedValue = IOUtil.readData(in);
        this.newValue = IOUtil.readData(in);
    }
}

